/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import org.apereo.cas.audit.spi.resource.CredentialsAsFirstParameterResourceResolver;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionFactory;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.aspectj.lang.JoinPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="Audits")
public class CredentialsAsFirstParameterResourceResolverTests {
    @Test
    public void verifyCredential() {
        CredentialsAsFirstParameterResourceResolver resolver = new CredentialsAsFirstParameterResourceResolver();
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword()});
        Assertions.assertNotNull((Object)resolver.resolveFrom(jp, new Object()));
    }

    @Test
    public void verifyJsonCredential() {
        CredentialsAsFirstParameterResourceResolver resolver = new CredentialsAsFirstParameterResourceResolver();
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        UsernamePasswordCredential cred = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"casuser", (String)"p@ssword");
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{cred});
        Assertions.assertNotNull((Object)resolver.resolveFrom(jp, new Object()));
    }

    @Test
    public void verifyException() {
        CredentialsAsFirstParameterResourceResolver resolver = new CredentialsAsFirstParameterResourceResolver();
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword()});
        Assertions.assertNotNull((Object)resolver.resolveFrom(jp, (Exception)new AuthenticationException()));
    }

    @Test
    public void verifyTransaction() {
        CredentialsAsFirstParameterResourceResolver resolver = new CredentialsAsFirstParameterResourceResolver();
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[]{CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword((String)"casuser")})});
        Assertions.assertNotNull((Object)resolver.resolveFrom(jp, new Object()));
    }
}

