/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.audit.spi.resource.ProtocolSpecificationValidationAuditResourceResolver;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.aspectj.lang.JoinPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="Audits")
public class ProtocolSpecificationValidationAuditResourceResolverTests {
    @Test
    public void verifyOperation() {
        CasConfigurationProperties props = new CasConfigurationProperties();
        props.getAudit().getEngine().setIncludeValidationAssertion(true);
        ProtocolSpecificationValidationAuditResourceResolver resolver = new ProtocolSpecificationValidationAuditResourceResolver(props);
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Mockito.when((Object)assertion.getService()).thenReturn((Object)RegisteredServiceTestUtils.getService());
        Mockito.when((Object)assertion.getPrimaryAuthentication()).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        resolver.setAuditFormat(AuditTrailManager.AuditFormats.JSON);
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{new MockHttpServletRequest(), assertion});
        String[] results = resolver.resolveFrom(jp, new Object());
        Assertions.assertTrue((results.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyNoOp() {
        CasConfigurationProperties props = new CasConfigurationProperties();
        props.getAudit().getEngine().setIncludeValidationAssertion(true);
        ProtocolSpecificationValidationAuditResourceResolver resolver = new ProtocolSpecificationValidationAuditResourceResolver(props);
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)ArrayUtils.EMPTY_OBJECT_ARRAY);
        String[] results = resolver.resolveFrom(jp, new Object());
        Assertions.assertEquals((int)0, (int)results.length);
    }
}

