/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import org.apereo.cas.audit.spi.resource.TicketAsFirstParameterResourceResolver;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.aspectj.lang.JoinPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="Audits")
public class TicketAsFirstParameterResourceResolverTests {
    @Test
    public void verifyOperation() {
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{"ST-123434"});
        TicketAsFirstParameterResourceResolver resolver = new TicketAsFirstParameterResourceResolver();
        String[] input = resolver.resolveFrom(jp, null);
        Assertions.assertTrue((input.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyTicketWithService() {
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{"ST-123434", RegisteredServiceTestUtils.getService()});
        TicketAsFirstParameterResourceResolver resolver = new TicketAsFirstParameterResourceResolver();
        String[] input = resolver.resolveFrom(jp, null);
        Assertions.assertTrue((input.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyTicketWithServiceAsJson() {
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{"ST-123434", RegisteredServiceTestUtils.getService()});
        TicketAsFirstParameterResourceResolver resolver = new TicketAsFirstParameterResourceResolver();
        resolver.setAuditFormat(AuditTrailManager.AuditFormats.JSON);
        String[] input = resolver.resolveFrom(jp, null);
        Assertions.assertTrue((input.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyNullOperation() {
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        TicketAsFirstParameterResourceResolver resolver = new TicketAsFirstParameterResourceResolver();
        String[] input = resolver.resolveFrom(jp, null);
        Assertions.assertEquals((int)input.length, (int)0);
    }
}

