/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import java.util.HashMap;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.util.AopUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.aspectj.lang.JoinPoint;

public class ServiceAuditResourceResolver
implements AuditResourceResolver {
    protected final AuthenticationServiceSelectionPlan serviceSelectionStrategy;
    protected final AuditEngineProperties properties;

    public String[] resolveFrom(JoinPoint joinPoint, Object retval) {
        AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)this.properties.getAuditFormat().name());
        Service service = (Service)AopUtils.unWrapJoinPoint((JoinPoint)joinPoint).getArgs()[1];
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("ticketId", retval.toString());
        values.put("service", this.getServiceId(service));
        return new String[]{auditFormat.serialize(values)};
    }

    public String[] resolveFrom(JoinPoint joinPoint, Exception ex) {
        AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)this.properties.getAuditFormat().name());
        Service service = (Service)AopUtils.unWrapJoinPoint((JoinPoint)joinPoint).getArgs()[1];
        return new String[]{auditFormat.serialize((Object)this.getServiceId(service))};
    }

    private String getServiceId(Service service) {
        String serviceId = (String)FunctionUtils.doUnchecked(() -> this.serviceSelectionStrategy.resolveService(service).getId());
        return DigestUtils.abbreviate((String)serviceId, (int)this.properties.getAbbreviationLength());
    }

    @Generated
    public ServiceAuditResourceResolver(AuthenticationServiceSelectionPlan serviceSelectionStrategy, AuditEngineProperties properties) {
        this.serviceSelectionStrategy = serviceSelectionStrategy;
        this.properties = properties;
    }
}

