/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import org.apereo.cas.audit.spi.PrincipalIdProvider;
import org.apereo.cas.audit.spi.ThreadLocalPrincipalResolver;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CurrentCredentialsAndAuthentication;
import org.apereo.cas.authentication.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ThreadLocalPrincipalResolverTests {
    private ThreadLocalPrincipalResolver theResolver = new ThreadLocalPrincipalResolver(new PrincipalIdProvider(){});

    @After
    public void cleanup() {
        CurrentCredentialsAndAuthentication.clear();
    }

    @Test
    public void noAuthenticationOrCrendentialsAvailableInThreadLocal() {
        this.assertResolvedPrincipal("audit:unknown");
    }

    @Test
    public void singleThreadSetsSingleCredential() {
        CurrentCredentialsAndAuthentication.bindCurrent((Credential[])new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.assertResolvedPrincipal("test");
    }

    @Test
    public void singleThreadSetsMultipleCredentials() {
        CurrentCredentialsAndAuthentication.bindCurrent((Credential[])new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword(), TestUtils.getCredentialsWithSameUsernameAndPassword((String)"test2")});
        this.assertResolvedPrincipal(String.format("%s, %s", "test", "test2"));
    }

    @Test
    public void singleThreadSetsAuthentication() {
        CurrentCredentialsAndAuthentication.bindCurrent((Authentication)TestUtils.getAuthentication());
        this.assertResolvedPrincipal("test");
    }

    private void assertResolvedPrincipal(String principalId) {
        Assert.assertEquals((Object)principalId, (Object)this.theResolver.resolveFrom(null, null));
    }
}

