/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import org.apereo.cas.AbstractCentralAuthenticationServiceTests;
import org.apereo.cas.audit.spi.TicketOrCredentialPrincipalResolver;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.TestUtils;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.aspectj.lang.JoinPoint;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TicketOrCredentialPrincipalResolverTests
extends AbstractCentralAuthenticationServiceTests {
    @Test
    public void verifyResolverByUnknownUser() {
        TicketOrCredentialPrincipalResolver res = new TicketOrCredentialPrincipalResolver(this.getCentralAuthenticationService());
        Assert.assertEquals((Object)res.resolve(), (Object)"audit:unknown");
    }

    @Test
    public void verifyResolverCredential() {
        TicketOrCredentialPrincipalResolver res = new TicketOrCredentialPrincipalResolver(this.getCentralAuthenticationService());
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword();
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{c});
        String result = res.resolveFrom(jp, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)c.toString());
    }

    @Test
    public void verifyResolverServiceTicket() throws Exception {
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword();
        AuthenticationResult ctx = TestUtils.getAuthenticationResult((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[]{c});
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket st = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService(), ctx);
        TicketOrCredentialPrincipalResolver res = new TicketOrCredentialPrincipalResolver(this.getCentralAuthenticationService());
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{st.getId()});
        String result = res.resolveFrom(jp, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)c.getId());
    }

    @Test
    public void verifyResolverTicketGrantingTicket() throws Exception {
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword();
        AuthenticationResult ctx = TestUtils.getAuthenticationResult((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Credential[])new Credential[]{c});
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(ctx);
        ServiceTicket st = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService(), ctx);
        TicketOrCredentialPrincipalResolver res = new TicketOrCredentialPrincipalResolver(this.getCentralAuthenticationService());
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{ticketId.getId()});
        String result = res.resolveFrom(jp, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)c.getId());
    }
}

