/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.spi.principal.DefaultAuditPrincipalIdProvider;
import org.apereo.cas.audit.spi.principal.ThreadLocalPrincipalResolver;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ThreadLocalPrincipalResolverTests {
    private final ThreadLocalPrincipalResolver theResolver = new ThreadLocalPrincipalResolver((AuditPrincipalIdProvider)new DefaultAuditPrincipalIdProvider());

    @After
    public void cleanup() {
        AuthenticationCredentialsThreadLocalBinder.clear();
    }

    @Test
    public void noAuthenticationOrCredentialsAvailableInThreadLocal() {
        this.assertResolvedPrincipal("audit:unknown");
    }

    @Test
    public void singleThreadSetsSingleCredential() {
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Credential[])new Credential[]{CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.assertResolvedPrincipal("test");
    }

    @Test
    public void singleThreadSetsMultipleCredentials() {
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Credential[])new Credential[]{CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword(), CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword((String)"test2")});
        this.assertResolvedPrincipal(String.format("%s, %s", "test", "test2"));
    }

    @Test
    public void singleThreadSetsAuthentication() {
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)CoreAuthenticationTestUtils.getAuthentication());
        this.assertResolvedPrincipal("test");
    }

    private void assertResolvedPrincipal(String principalId) {
        Assert.assertEquals((Object)principalId, (Object)this.theResolver.resolveFrom(null, null));
    }
}

