/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.spi.principal.DefaultAuditPrincipalIdProvider;
import org.apereo.cas.audit.spi.principal.ThreadLocalAuditPrincipalResolver;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Audits")
public class ThreadLocalAuditPrincipalResolverTests {
    private final ThreadLocalAuditPrincipalResolver theResolver = new ThreadLocalAuditPrincipalResolver((AuditPrincipalIdProvider)new DefaultAuditPrincipalIdProvider());

    @AfterEach
    public void cleanup() {
        AuthenticationCredentialsThreadLocalBinder.clear();
    }

    @Test
    public void noAuthenticationOrCredentialsAvailableInThreadLocal() {
        this.assertResolvedPrincipal("audit:unknown");
    }

    @Test
    public void singleThreadSetsSingleCredential() {
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Credential[])new Credential[]{CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.assertResolvedPrincipal("test");
    }

    @Test
    public void singleThreadSetsMultipleCredentials() {
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Credential[])new Credential[]{CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword(), CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword((String)"test2")});
        this.assertResolvedPrincipal(String.format("%s, %s", "test", "test2"));
    }

    @Test
    public void singleThreadSetsAuthentication() {
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)CoreAuthenticationTestUtils.getAuthentication());
        this.assertResolvedPrincipal("test");
    }

    private void assertResolvedPrincipal(String principalId) {
        Assertions.assertEquals((Object)principalId, (Object)this.theResolver.resolveFrom(null, null));
        Assertions.assertEquals((Object)"audit:unknown", (Object)this.theResolver.resolve());
    }
}

