/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.audit.spi.resource.TicketValidationResourceResolver;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.aspectj.lang.JoinPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="Audits")
public class TicketValidationResourceResolverTests {
    private TicketValidationResourceResolver resolver;

    @BeforeEach
    public void setup() {
        this.resolver = new TicketValidationResourceResolver();
    }

    @Test
    public void verifyActionPassedJson() {
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)ArrayUtils.EMPTY_OBJECT_ARRAY);
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Mockito.when((Object)assertion.getPrimaryAuthentication()).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        this.resolver.setAuditFormat(AuditTrailManager.AuditFormats.JSON);
        Assertions.assertTrue((this.resolver.resolveFrom(jp, (Object)assertion).length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyActionPassed() {
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)ArrayUtils.EMPTY_OBJECT_ARRAY);
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Mockito.when((Object)assertion.getPrimaryAuthentication()).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        Assertions.assertTrue((this.resolver.resolveFrom(jp, (Object)assertion).length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyTicketId() {
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{"ticket-id"});
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Mockito.when((Object)assertion.getPrimaryAuthentication()).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        Assertions.assertTrue((this.resolver.resolveFrom(jp, (Object)assertion).length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyTicketIdJson() {
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{"ticket-id"});
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Mockito.when((Object)assertion.getPrimaryAuthentication()).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        this.resolver.setAuditFormat(AuditTrailManager.AuditFormats.JSON);
        Assertions.assertTrue((this.resolver.resolveFrom(jp, (Object)assertion).length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void verifyEmpty() {
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)ArrayUtils.EMPTY_OBJECT_ARRAY);
        Assertions.assertEquals((int)this.resolver.resolveFrom(jp, new Object()).length, (int)0);
    }
}

