/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;

public abstract class AbstractMultifactorAuthenticationProvider
implements MultifactorAuthenticationProvider,
Serializable {
    private static final long serialVersionUID = 4789727148134156909L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMultifactorAuthenticationProvider.class);
    private MultifactorAuthenticationProviderBypass bypassEvaluator;
    private String globalFailureMode;
    private String id;
    private int order;

    public String getId() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setGlobalFailureMode(String globalFailureMode) {
        this.globalFailureMode = globalFailureMode;
    }

    public final boolean supports(Event event, Authentication authentication, RegisteredService registeredService, HttpServletRequest request) {
        if (event == null || !event.getId().matches(this.getId())) {
            LOGGER.debug("Provided event id [{}] is not applicable to this provider identified by [{}]", (Object)event, (Object)this.getId());
            return false;
        }
        if (this.bypassEvaluator != null && !this.bypassEvaluator.shouldMultifactorAuthenticationProviderExecute(authentication, registeredService, this, request)) {
            LOGGER.debug("Request cannot be supported by provider [{}] as it's configured for bypass", (Object)this.getId());
            return false;
        }
        if (this.supportsInternal(event, authentication, registeredService)) {
            LOGGER.debug("[{}] voted to support this authentication request", (Object)this.getClass().getSimpleName());
            return true;
        }
        LOGGER.debug("[{}] voted does not support this authentication request", (Object)this.getClass().getSimpleName());
        return false;
    }

    protected boolean supportsInternal(Event e, Authentication authentication, RegisteredService registeredService) {
        return true;
    }

    public boolean isAvailable(RegisteredService service) throws AuthenticationException {
        RegisteredServiceMultifactorPolicy.FailureModes failureMode = RegisteredServiceMultifactorPolicy.FailureModes.CLOSED;
        if (StringUtils.isNotBlank((CharSequence)this.globalFailureMode)) {
            failureMode = RegisteredServiceMultifactorPolicy.FailureModes.valueOf((String)this.globalFailureMode);
            LOGGER.debug("Using global multi-factor failure mode for [{}] defined as [{}]", (Object)service, (Object)failureMode);
        }
        if (service != null) {
            LOGGER.debug("Evaluating multifactor authentication policy for service [{}}", (Object)service);
            RegisteredServiceMultifactorPolicy policy = service.getMultifactorPolicy();
            if (policy.getFailureMode() != RegisteredServiceMultifactorPolicy.FailureModes.NOT_SET) {
                failureMode = policy.getFailureMode();
                LOGGER.debug("Multi-factor failure mode for [{}] is defined as [{}]", (Object)service.getServiceId(), (Object)failureMode);
            }
        }
        if (failureMode != RegisteredServiceMultifactorPolicy.FailureModes.NONE) {
            if (this.isAvailable()) {
                return true;
            }
            String providerName = this.getClass().getSimpleName();
            if (failureMode == RegisteredServiceMultifactorPolicy.FailureModes.CLOSED) {
                LOGGER.warn("[{}] could not be reached. Authentication shall fail for [{}]", (Object)providerName, (Object)service);
                throw new AuthenticationException();
            }
            LOGGER.warn("[{}] could not be reached. Since the authentication provider is configured for the failure mode of [{}] authentication will proceed without [{}] for service [{}]", new Object[]{providerName, failureMode, providerName, service});
            return false;
        }
        LOGGER.debug("Failure mode is set to [{}]. Assuming the provider is available.", (Object)failureMode);
        return true;
    }

    protected boolean isAvailable() {
        return true;
    }

    public void setBypassEvaluator(MultifactorAuthenticationProviderBypass bypassEvaluator) {
        this.bypassEvaluator = bypassEvaluator;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MultifactorAuthenticationProvider rhs = (MultifactorAuthenticationProvider)obj;
        return new EqualsBuilder().append(this.getOrder(), rhs.getOrder()).append((Object)this.getId(), (Object)rhs.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getOrder()).append((Object)this.getId()).toHashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean matches(String identifier) {
        return this.getId().matches(identifier);
    }
}

