/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DefaultMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class RestMultifactorAuthenticationProviderBypass
extends DefaultMultifactorAuthenticationProviderBypass {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestMultifactorAuthenticationProviderBypass.class);
    private static final long serialVersionUID = -7553888418344342672L;

    public RestMultifactorAuthenticationProviderBypass(MultifactorAuthenticationProviderBypassProperties bypassProperties) {
        super(bypassProperties);
    }

    @Override
    public boolean shouldMultifactorAuthenticationProviderExecute(Authentication authentication, RegisteredService registeredService, MultifactorAuthenticationProvider provider, HttpServletRequest request) {
        try {
            HttpResponse response;
            Principal principal = authentication.getPrincipal();
            MultifactorAuthenticationProviderBypassProperties.Rest rest = this.bypassProperties.getRest();
            LOGGER.debug("Evaluating multifactor authentication bypass properties for principal [{}], service [{}] and provider [{}] via REST endpoint [{}]", new Object[]{principal.getId(), registeredService, provider, rest.getUrl()});
            Map parameters = CollectionUtils.wrap((String)"principal", (Object)CollectionUtils.wrap((Object)principal.getId()), (String)"provider", (Object)CollectionUtils.wrap((Object)provider.getId()));
            if (registeredService != null) {
                parameters.put("service", registeredService.getServiceId());
            }
            return (response = HttpUtils.execute((String)rest.getUrl(), (String)rest.getMethod(), (String)rest.getBasicAuthUsername(), (String)rest.getBasicAuthPassword(), (Map)parameters)).getStatusLine().getStatusCode() == HttpStatus.ACCEPTED.value();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return super.shouldMultifactorAuthenticationProviderExecute(authentication, registeredService, provider, request);
        }
    }
}

