/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.DefaultMultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.DefaultMultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.DefaultRequestedAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.RequestedAuthenticationContextValidator;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreMultifactorAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreMultifactorAuthenticationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private ObjectProvider<MultifactorAuthenticationTriggerSelectionStrategy> multifactorTriggerSelectionStrategy;

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"authenticationContextValidator"})
    public MultifactorAuthenticationContextValidator authenticationContextValidator() {
        MultifactorAuthenticationProperties mfa = this.casProperties.getAuthn().getMfa();
        String contextAttribute = mfa.getAuthenticationContextAttribute();
        String authnAttributeName = mfa.getTrusted().getAuthenticationContextAttribute();
        return new DefaultMultifactorAuthenticationContextValidator(contextAttribute, authnAttributeName, this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"requestedContextValidator"})
    public RequestedAuthenticationContextValidator<MultifactorAuthenticationProvider> requestedContextValidator() {
        return new DefaultRequestedAuthenticationContextValidator((ServicesManager)this.servicesManager.getObject(), (MultifactorAuthenticationTriggerSelectionStrategy)this.multifactorTriggerSelectionStrategy.getObject(), this.authenticationContextValidator(), (ApplicationContext)this.applicationContext);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"failureModeEvaluator"})
    public MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator() {
        return new DefaultMultifactorAuthenticationFailureModeEvaluator(this.casProperties);
    }
}

