/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.cookie.TicketGrantingCookieProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieGenerationContext;

public final class CookieUtils {
    public static TicketGrantingTicket getTicketGrantingTicketFromRequest(CasCookieBuilder ticketGrantingTicketCookieGenerator, TicketRegistry ticketRegistry, HttpServletRequest request) {
        TicketGrantingTicket tgt;
        String cookieValue = ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        if (StringUtils.isNotBlank((CharSequence)cookieValue) && (tgt = (TicketGrantingTicket)ticketRegistry.getTicket(cookieValue, TicketGrantingTicket.class)) != null && !tgt.isExpired()) {
            return tgt;
        }
        return null;
    }

    public static Optional<Cookie> getCookieFromRequest(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Arrays.stream(cookies).filter(c -> c.getName().equalsIgnoreCase(cookieName)).findFirst();
    }

    public static CookieGenerationContext buildCookieGenerationContext(CookieProperties cookie) {
        return CookieUtils.buildCookieGenerationContextBuilder(cookie).build();
    }

    public static CookieGenerationContext buildCookieGenerationContext(TicketGrantingCookieProperties cookie) {
        int rememberMeMaxAge = (int)Beans.newDuration((String)cookie.getRememberMeMaxAge()).getSeconds();
        CookieGenerationContext.CookieGenerationContextBuilder builder = CookieUtils.buildCookieGenerationContextBuilder((CookieProperties)cookie);
        return builder.rememberMeMaxAge(rememberMeMaxAge).build();
    }

    private static CookieGenerationContext.CookieGenerationContextBuilder buildCookieGenerationContextBuilder(CookieProperties cookie) {
        return CookieGenerationContext.builder().name(cookie.getName()).path(cookie.getPath()).maxAge(cookie.getMaxAge()).secure(cookie.isSecure()).domain(cookie.getDomain()).httpOnly(cookie.isHttpOnly());
    }

    @Generated
    private CookieUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

