/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.gen;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieGenerationContext;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.web.support.mgmr.NoOpCookieValueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.RequestContext;

public class CookieRetrievingCookieGenerator
extends CookieGenerator
implements Serializable,
CasCookieBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieRetrievingCookieGenerator.class);
    private static final long serialVersionUID = -4926982428809856313L;
    private final CookieValueManager casCookieValueManager;
    private final CookieGenerationContext cookieGenerationContext;

    public CookieRetrievingCookieGenerator(CookieGenerationContext context) {
        this(context, NoOpCookieValueManager.INSTANCE);
    }

    public CookieRetrievingCookieGenerator(CookieGenerationContext context, CookieValueManager casCookieValueManager) {
        super.setCookieName(context.getName());
        super.setCookiePath(context.getPath());
        super.setCookieMaxAge(Integer.valueOf(context.getMaxAge()));
        super.setCookieSecure(context.isSecure());
        super.setCookieHttpOnly(context.isHttpOnly());
        this.setCookieDomain(context.getDomain());
        this.cookieGenerationContext = context;
        this.casCookieValueManager = casCookieValueManager;
    }

    public void addCookie(RequestContext requestContext, String cookieValue) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        String theCookieValue = this.casCookieValueManager.buildCookieValue(cookieValue, request);
        if (CookieRetrievingCookieGenerator.isRememberMeAuthentication(requestContext).booleanValue()) {
            LOGGER.trace("Creating cookie [{}] for remember-me authentication", (Object)this.getCookieName());
            Cookie cookie = this.createCookie(theCookieValue);
            cookie.setMaxAge(this.cookieGenerationContext.getRememberMeMaxAge());
            cookie.setSecure(this.isCookieSecure());
            cookie.setHttpOnly(this.isCookieHttpOnly());
            cookie.setComment("CAS Cookie w/ Remember-Me");
            response.addCookie(cookie);
        } else {
            LOGGER.trace("Creating cookie [{}]", (Object)this.getCookieName());
            super.addCookie(response, theCookieValue);
        }
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieValue) {
        String theCookieValue = this.casCookieValueManager.buildCookieValue(cookieValue, request);
        LOGGER.trace("Creating cookie [{}]", (Object)this.getCookieName());
        super.addCookie(response, theCookieValue);
    }

    public String retrieveCookieValue(HttpServletRequest request) {
        try {
            String cookieValue;
            Cookie cookie = org.springframework.web.util.WebUtils.getCookie((HttpServletRequest)request, (String)Objects.requireNonNull(this.getCookieName()));
            if (cookie == null && StringUtils.isNotBlank((CharSequence)(cookieValue = request.getHeader(this.getCookieName())))) {
                LOGGER.trace("Found cookie [{}] under header name [{}]", (Object)cookieValue, (Object)this.getCookieName());
                cookie = this.createCookie(cookieValue);
            }
            if (cookie == null && StringUtils.isNotBlank((CharSequence)(cookieValue = request.getParameter(this.getCookieName())))) {
                LOGGER.trace("Found cookie [{}] under request parameter name [{}]", (Object)cookieValue, (Object)this.getCookieName());
                cookie = this.createCookie(cookieValue);
            }
            return Optional.ofNullable(cookie).map(ck -> this.casCookieValueManager.obtainCookieValue(ck, request)).orElse(null);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setCookieDomain(String cookieDomain) {
        super.setCookieDomain((String)StringUtils.defaultIfEmpty((CharSequence)cookieDomain, null));
    }

    private static Boolean isRememberMeAuthentication(RequestContext requestContext) {
        if (CookieRetrievingCookieGenerator.isRememberMeProvidedInRequest(requestContext)) {
            LOGGER.debug("This request is from a remember-me authentication event");
            return Boolean.TRUE;
        }
        if (CookieRetrievingCookieGenerator.isRememberMeRecordedInAuthentication(requestContext).booleanValue()) {
            LOGGER.debug("The recorded authentication is from a remember-me request");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Cookie createCookie(String cookieValue) {
        Cookie c = super.createCookie(cookieValue);
        c.setComment("CAS Cookie");
        return c;
    }

    private static Boolean isRememberMeRecordedInAuthentication(RequestContext requestContext) {
        LOGGER.debug("Request does not indicate a remember-me authentication event. Locating authentication object from the request context...");
        Authentication auth = WebUtils.getAuthentication((RequestContext)requestContext);
        if (auth == null) {
            return Boolean.FALSE;
        }
        Map attributes = auth.getAttributes();
        LOGGER.trace("Located authentication attributes [{}]", (Object)attributes);
        if (attributes.containsKey("org.apereo.cas.authentication.principal.REMEMBER_ME")) {
            List rememberMeValue = (List)attributes.get("org.apereo.cas.authentication.principal.REMEMBER_ME");
            LOGGER.debug("Located remember-me authentication attribute [{}]", (Object)rememberMeValue);
            return rememberMeValue.contains(Boolean.TRUE);
        }
        return Boolean.FALSE;
    }

    private static boolean isRememberMeProvidedInRequest(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String value = request.getParameter("rememberMe");
        LOGGER.trace("Locating request parameter [{}] with value [{}]", (Object)"rememberMe", (Object)value);
        return StringUtils.isNotBlank((CharSequence)value) && WebUtils.isRememberMeAuthenticationEnabled((RequestContext)requestContext) != false;
    }
}

