/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.mgmr;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.support.mgmr.EncryptedCookieValueManager;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasCookieValueManager
extends EncryptedCookieValueManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasCookieValueManager.class);
    private static final char COOKIE_FIELD_SEPARATOR = '@';
    private static final int COOKIE_FIELDS_LENGTH = 3;
    private static final long serialVersionUID = -2696352696382374584L;
    private final CookieProperties cookieProperties;

    public DefaultCasCookieValueManager(CipherExecutor<Serializable, Serializable> cipherExecutor, CookieProperties cookieProperties) {
        super(cipherExecutor);
        this.cookieProperties = cookieProperties;
    }

    @Override
    protected String buildCompoundCookieValue(String givenCookieValue, HttpServletRequest request) {
        StringBuilder builder = new StringBuilder(givenCookieValue);
        if (this.cookieProperties.isPinToSession()) {
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            builder.append('@').append(clientInfo.getClientIpAddress());
            String userAgent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
            if (StringUtils.isBlank((CharSequence)userAgent)) {
                throw new IllegalStateException("Request does not specify a user-agent");
            }
            builder.append('@').append(userAgent);
        } else {
            LOGGER.trace("Cookie session-pinning is disabled");
        }
        return builder.toString();
    }

    @Override
    protected String obtainValueFromCompoundCookie(String cookieValue, HttpServletRequest request) {
        List cookieParts = Splitter.on((String)String.valueOf('@')).splitToList((CharSequence)cookieValue);
        if (cookieParts.isEmpty()) {
            throw new IllegalStateException("Invalid empty cookie");
        }
        String value = (String)cookieParts.get(0);
        if (!this.cookieProperties.isPinToSession()) {
            LOGGER.trace("Cookie session-pinning is disabled. Returning cookie value as it was provided");
            return value;
        }
        if (cookieParts.size() != 3) {
            throw new IllegalStateException("Invalid cookie. Required fields are missing");
        }
        String remoteAddr = (String)cookieParts.get(1);
        String userAgent = (String)cookieParts.get(2);
        if (Stream.of(value, remoteAddr, userAgent).anyMatch(StringUtils::isBlank)) {
            throw new IllegalStateException("Invalid cookie. Required fields are empty");
        }
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (!remoteAddr.equals(clientInfo.getClientIpAddress())) {
            throw new IllegalStateException("Invalid cookie. Required remote address " + remoteAddr + " does not match " + clientInfo.getClientIpAddress());
        }
        String agent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (!userAgent.equals(agent)) {
            throw new IllegalStateException("Invalid cookie. Required user-agent " + userAgent + " does not match " + agent);
        }
        return value;
    }
}

