/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.mgmr;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.apereo.cas.web.cookie.CookieGenerationContext;
import org.apereo.cas.web.cookie.CookieSameSitePolicy;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class DefaultCookieSameSitePolicy
implements CookieSameSitePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCookieSameSitePolicy.class);
    public static final CookieSameSitePolicy INSTANCE = new DefaultCookieSameSitePolicy();

    public Optional<String> build(HttpServletRequest request, HttpServletResponse response, CookieGenerationContext cookieGenerationContext) {
        String sameSitePolicy = cookieGenerationContext.getSameSitePolicy();
        if (ResourceUtils.doesResourceExist((String)sameSitePolicy)) {
            return this.buildSameSitePolicyFromScript(request, response, cookieGenerationContext);
        }
        if (sameSitePolicy.contains(".")) {
            return ((CookieSameSitePolicy)Unchecked.supplier(() -> {
                Class clazz = ClassUtils.getClass((ClassLoader)CookieSameSitePolicy.class.getClassLoader(), (String)sameSitePolicy);
                return (CookieSameSitePolicy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }).get()).build(request, response, cookieGenerationContext);
        }
        CookieSameSitePolicy result = switch (sameSitePolicy.toLowerCase(Locale.ENGLISH).trim()) {
            case "strict" -> CookieSameSitePolicy.strict();
            case "lax" -> CookieSameSitePolicy.lax();
            case "off" -> CookieSameSitePolicy.off();
            default -> CookieSameSitePolicy.none();
        };
        return result.build(request, response, cookieGenerationContext);
    }

    protected Optional<String> buildSameSitePolicyFromScript(HttpServletRequest request, HttpServletResponse response, CookieGenerationContext cookieGenerationContext) {
        return (Optional)FunctionUtils.doUnchecked(() -> {
            String sameSitePolicy = cookieGenerationContext.getSameSitePolicy();
            AbstractResource resource = ResourceUtils.getResourceFrom((String)sameSitePolicy);
            try (WatchableGroovyScriptResource groovyResource = new WatchableGroovyScriptResource((Resource)resource, false);){
                Optional<String> optional = Optional.ofNullable((String)groovyResource.execute(new Object[]{request, response, cookieGenerationContext, LOGGER}, String.class));
                return optional;
            }
        });
    }

    @Generated
    protected DefaultCookieSameSitePolicy() {
    }
}

