/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging.config;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.web.Log4jServletContextListener;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logging.web.LoggingConfigurationEndpoint;
import org.apereo.cas.logging.web.ThreadContextMDCServletFilter;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;

@Configuration(value="casLoggingConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasLoggingConfiguration {
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;

    @ConditionalOnBean(value={TicketRegistry.class})
    @ConditionalOnProperty(prefix="cas.logging", name={"mdcEnabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    public FilterRegistrationBean threadContextMDCServletFilter() {
        ThreadContextMDCServletFilter filter = new ThreadContextMDCServletFilter((TicketRegistrySupport)this.ticketRegistrySupport.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject());
        HashMap initParams = new HashMap();
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)filter);
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setInitParameters(initParams);
        bean.setName("threadContextMDCServletFilter");
        bean.setOrder(-2147483647);
        return bean;
    }

    @ConditionalOnClass(value={LoggerContext.class})
    @Configuration(value="casLog4jConfiguration")
    public static class CasLog4jConfiguration {
        @Autowired
        private CasConfigurationProperties casProperties;
        @Autowired
        private ResourceLoader resourceLoader;
        @Autowired
        private Environment environment;

        @Bean
        @ConditionalOnAvailableEndpoint
        public LoggingConfigurationEndpoint loggingConfigurationEndpoint() {
            return new LoggingConfigurationEndpoint(this.casProperties, this.resourceLoader, this.environment);
        }

        @Bean
        @Lazy
        public ServletListenerRegistrationBean log4jServletContextListener() {
            ServletListenerRegistrationBean bean = new ServletListenerRegistrationBean();
            bean.setEnabled(true);
            bean.setListener((EventListener)new Log4jServletContextListener());
            return bean;
        }
    }
}

