/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging.web;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.slf4j.MDC;

public class ThreadContextMDCServletFilter
implements Filter {
    private final TicketRegistrySupport ticketRegistrySupport;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;

    private static void addContextAttribute(String attributeName, Object value) {
        String result = Optional.ofNullable(value).map(Object::toString).orElse(null);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            MDC.put((String)attributeName, (String)result);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            Principal p;
            String cookieValue;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            ThreadContextMDCServletFilter.addContextAttribute("remoteAddress", request.getRemoteAddr());
            ThreadContextMDCServletFilter.addContextAttribute("remoteUser", request.getRemoteUser());
            ThreadContextMDCServletFilter.addContextAttribute("serverName", request.getServerName());
            ThreadContextMDCServletFilter.addContextAttribute("serverPort", String.valueOf(request.getServerPort()));
            ThreadContextMDCServletFilter.addContextAttribute("locale", request.getLocale().getDisplayName());
            ThreadContextMDCServletFilter.addContextAttribute("contentType", request.getContentType());
            ThreadContextMDCServletFilter.addContextAttribute("contextPath", request.getContextPath());
            ThreadContextMDCServletFilter.addContextAttribute("localAddress", request.getLocalAddr());
            ThreadContextMDCServletFilter.addContextAttribute("localPort", String.valueOf(request.getLocalPort()));
            ThreadContextMDCServletFilter.addContextAttribute("remotePort", String.valueOf(request.getRemotePort()));
            ThreadContextMDCServletFilter.addContextAttribute("pathInfo", request.getPathInfo());
            ThreadContextMDCServletFilter.addContextAttribute("protocol", request.getProtocol());
            ThreadContextMDCServletFilter.addContextAttribute("authType", request.getAuthType());
            ThreadContextMDCServletFilter.addContextAttribute("method", request.getMethod());
            ThreadContextMDCServletFilter.addContextAttribute("queryString", request.getQueryString());
            ThreadContextMDCServletFilter.addContextAttribute("requestUri", request.getRequestURI());
            ThreadContextMDCServletFilter.addContextAttribute("scheme", request.getScheme());
            ThreadContextMDCServletFilter.addContextAttribute("timezone", TimeZone.getDefault().getDisplayName());
            Map params = request.getParameterMap();
            params.keySet().stream().filter(k -> !k.equalsIgnoreCase("password")).forEach(k -> {
                Object[] values = (String[])params.get(k);
                ThreadContextMDCServletFilter.addContextAttribute(k, Arrays.toString(values));
            });
            Collections.list(request.getAttributeNames()).forEach(a -> ThreadContextMDCServletFilter.addContextAttribute(a, request.getAttribute(a)));
            Enumeration requestHeaderNames = request.getHeaderNames();
            if (requestHeaderNames != null) {
                Collections.list(requestHeaderNames).forEach(h -> ThreadContextMDCServletFilter.addContextAttribute(h, request.getHeader(h)));
            }
            if (StringUtils.isNotBlank((CharSequence)(cookieValue = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request))) && (p = this.ticketRegistrySupport.getAuthenticatedPrincipalFrom(cookieValue)) != null) {
                ThreadContextMDCServletFilter.addContextAttribute("principal", p.getId());
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            MDC.clear();
        }
    }

    public void destroy() {
    }

    @Generated
    public ThreadContextMDCServletFilter(TicketRegistrySupport ticketRegistrySupport, CasCookieBuilder ticketGrantingTicketCookieGenerator) {
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }
}

