/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.net.URL;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.logout.DefaultLogoutRequest;
import org.apereo.cas.logout.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.LogoutHttpMessage;
import org.apereo.cas.logout.LogoutMessageCreator;
import org.apereo.cas.logout.LogoutRequest;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.logout.SamlCompliantLogoutMessageCreator;
import org.apereo.cas.logout.SingleLogoutService;
import org.apereo.cas.logout.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.SingleLogoutServiceMessageHandler;
import org.apereo.cas.services.LogoutType;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSingleLogoutServiceMessageHandler
implements SingleLogoutServiceMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSingleLogoutServiceMessageHandler.class);
    private ServicesManager servicesManager;
    private HttpClient httpClient;
    private boolean asynchronous = true;
    private LogoutMessageCreator logoutMessageBuilder = new SamlCompliantLogoutMessageCreator();
    private SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder = new DefaultSingleLogoutServiceLogoutUrlBuilder();

    public void setAsynchronous(boolean asyncCallbacks) {
        this.asynchronous = asyncCallbacks;
    }

    public LogoutRequest handle(SingleLogoutService singleLogoutService, String ticketId) {
        RegisteredService registeredService;
        if (!singleLogoutService.isLoggedOutAlready() && DefaultSingleLogoutServiceMessageHandler.serviceSupportsSingleLogout(registeredService = this.servicesManager.findServiceBy((Service)singleLogoutService))) {
            URL logoutUrl = this.singleLogoutServiceLogoutUrlBuilder.determineLogoutUrl(registeredService, singleLogoutService);
            DefaultLogoutRequest logoutRequest = new DefaultLogoutRequest(ticketId, singleLogoutService, logoutUrl);
            LogoutType type = registeredService.getLogoutType() == null ? LogoutType.BACK_CHANNEL : registeredService.getLogoutType();
            switch (type) {
                case BACK_CHANNEL: {
                    if (this.performBackChannelLogout(logoutRequest)) {
                        logoutRequest.setStatus(LogoutRequestStatus.SUCCESS);
                        break;
                    }
                    logoutRequest.setStatus(LogoutRequestStatus.FAILURE);
                    LOGGER.warn("Logout message not sent to [{}]; Continuing processing...", (Object)singleLogoutService.getId());
                    break;
                }
                default: {
                    logoutRequest.setStatus(LogoutRequestStatus.NOT_ATTEMPTED);
                }
            }
            return logoutRequest;
        }
        return null;
    }

    public boolean performBackChannelLogout(LogoutRequest request) {
        try {
            String logoutRequest = this.logoutMessageBuilder.create(request);
            SingleLogoutService logoutService = request.getService();
            logoutService.setLoggedOutAlready(true);
            LOGGER.debug("Sending logout request for [{}] to [{}]", (Object)logoutService.getId(), (Object)request.getLogoutUrl());
            LogoutHttpMessage msg = new LogoutHttpMessage(request.getLogoutUrl(), logoutRequest, this.asynchronous);
            LOGGER.debug("Prepared logout message to send is [{}]", (Object)msg);
            return this.httpClient.sendMessageToEndPoint((HttpMessage)msg);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static boolean serviceSupportsSingleLogout(RegisteredService registeredService) {
        return registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed() && registeredService.getLogoutType() != LogoutType.NONE;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setLogoutMessageBuilder(LogoutMessageCreator logoutMessageBuilder) {
        this.logoutMessageBuilder = logoutMessageBuilder;
    }

    public void setSingleLogoutServiceLogoutUrlBuilder(SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder) {
        this.singleLogoutServiceLogoutUrlBuilder = singleLogoutServiceLogoutUrlBuilder;
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public SingleLogoutServiceLogoutUrlBuilder getSingleLogoutServiceLogoutUrlBuilder() {
        return this.singleLogoutServiceLogoutUrlBuilder;
    }

    public LogoutMessageCreator getLogoutMessageBuilder() {
        return this.logoutMessageBuilder;
    }
}

