/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutMessageCreator;
import org.apereo.cas.logout.LogoutRequest;
import org.apereo.cas.logout.SingleLogoutService;
import org.apereo.cas.logout.SingleLogoutServiceMessageHandler;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CompressionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutManagerImpl
implements LogoutManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutManagerImpl.class);
    private boolean singleLogoutCallbacksDisabled;
    private LogoutMessageCreator logoutMessageBuilder;
    private SingleLogoutServiceMessageHandler singleLogoutServiceMessageHandler;

    public LogoutManagerImpl() {
    }

    public LogoutManagerImpl(LogoutMessageCreator logoutMessageBuilder) {
        this.logoutMessageBuilder = logoutMessageBuilder;
    }

    public List<LogoutRequest> performLogout(TicketGrantingTicket ticket) {
        LOGGER.info("Performing logout operations for [{}]", (Object)ticket.getId());
        ArrayList<LogoutRequest> logoutRequests = new ArrayList<LogoutRequest>();
        if (this.singleLogoutCallbacksDisabled) {
            LOGGER.info("Single logout callbacks are disabled");
            return logoutRequests;
        }
        this.performLogoutForTicket(ticket, logoutRequests);
        LOGGER.info("{} logout requests were processed", (Object)logoutRequests.size());
        return logoutRequests;
    }

    private void performLogoutForTicket(TicketGrantingTicket ticket, List<LogoutRequest> logoutRequests) {
        ticket.getServices().entrySet().stream().filter(entry -> entry.getValue() instanceof SingleLogoutService).forEach(entry -> {
            Service service = (Service)entry.getValue();
            LOGGER.debug("Handling single logout callback for {}", (Object)service);
            LogoutRequest logoutRequest = this.singleLogoutServiceMessageHandler.handle((SingleLogoutService)service, (String)entry.getKey());
            if (logoutRequest != null) {
                LOGGER.debug("Captured logout request [{}]", (Object)logoutRequest);
                logoutRequests.add(logoutRequest);
            }
        });
        Collection proxyGrantingTickets = ticket.getProxyGrantingTickets();
        if (proxyGrantingTickets.isEmpty()) {
            LOGGER.debug("There are no proxy-granting tickets associated with [{}] to process for single logout", (Object)ticket.getId());
        } else {
            proxyGrantingTickets.stream().forEach(proxyGrantingTicket -> this.performLogoutForTicket((TicketGrantingTicket)proxyGrantingTicket, logoutRequests));
        }
    }

    public String createFrontChannelLogoutMessage(LogoutRequest logoutRequest) {
        String logoutMessage = this.logoutMessageBuilder.create(logoutRequest);
        LOGGER.trace("Attempting to deflate the logout message [{}]", (Object)logoutMessage);
        return CompressionUtils.deflate((String)logoutMessage);
    }

    public void setSingleLogoutCallbacksDisabled(boolean singleLogoutCallbacksDisabled) {
        this.singleLogoutCallbacksDisabled = singleLogoutCallbacksDisabled;
    }

    public void setLogoutMessageBuilder(LogoutMessageCreator logoutMessageBuilder) {
        this.logoutMessageBuilder = logoutMessageBuilder;
    }

    public void setSingleLogoutServiceMessageHandler(SingleLogoutServiceMessageHandler singleLogoutServiceMessageHandler) {
        this.singleLogoutServiceMessageHandler = singleLogoutServiceMessageHandler;
    }

    public SingleLogoutServiceMessageHandler getSingleLogoutServiceMessageHandler() {
        return this.singleLogoutServiceMessageHandler;
    }
}

