/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.logout.DefaultLogoutManager;
import org.apereo.cas.logout.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.DefaultSingleLogoutServiceMessageHandler;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutMessageCreator;
import org.apereo.cas.logout.LogoutRequest;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.logout.SamlCompliantLogoutMessageCreator;
import org.apereo.cas.logout.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.SingleLogoutServiceMessageHandler;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpMessage;
import org.apereo.cas.web.SimpleUrlValidatorFactoryBean;
import org.apereo.cas.web.UrlValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DefaultLogoutManagerTests {
    private static final String ID = "id";
    private static final String URL = "http://www.github.com";
    private DefaultLogoutManager logoutManager;
    @Mock
    private TicketGrantingTicket tgt;
    private AbstractWebApplicationService simpleWebApplicationServiceImpl;
    private AbstractRegisteredService registeredService;
    @Mock
    private ServicesManager servicesManager;
    @Mock
    private HttpClient client;
    private DefaultSingleLogoutServiceMessageHandler singleLogoutServiceMessageHandler;

    public DefaultLogoutManagerTests() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.client.isValidEndPoint((String)Mockito.any(String.class))).thenReturn((Object)true);
        Mockito.when((Object)this.client.isValidEndPoint((URL)Mockito.any(URL.class))).thenReturn((Object)true);
        Mockito.when((Object)this.client.sendMessageToEndPoint((HttpMessage)Mockito.any(HttpMessage.class))).thenReturn((Object)true);
        UrlValidator validator = new SimpleUrlValidatorFactoryBean(true).getObject();
        this.singleLogoutServiceMessageHandler = new DefaultSingleLogoutServiceMessageHandler(this.client, (LogoutMessageCreator)new SamlCompliantLogoutMessageCreator(), this.servicesManager, (SingleLogoutServiceLogoutUrlBuilder)new DefaultSingleLogoutServiceLogoutUrlBuilder(validator), true, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        HashMap<String, AbstractWebApplicationService> services = new HashMap<String, AbstractWebApplicationService>();
        this.simpleWebApplicationServiceImpl = RegisteredServiceTestUtils.getService((String)URL);
        services.put(ID, this.simpleWebApplicationServiceImpl);
        Mockito.when((Object)this.tgt.getServices()).thenReturn(services);
        this.logoutManager = new DefaultLogoutManager((LogoutMessageCreator)new SamlCompliantLogoutMessageCreator(), (SingleLogoutServiceMessageHandler)this.singleLogoutServiceMessageHandler, false, (LogoutExecutionPlan)Mockito.mock(LogoutExecutionPlan.class));
        this.registeredService = RegisteredServiceTestUtils.getRegisteredService((String)URL);
        Mockito.when((Object)this.servicesManager.findServiceBy((Service)this.simpleWebApplicationServiceImpl)).thenReturn((Object)this.registeredService);
    }

    @Test
    public void verifyServiceLogoutUrlIsUsed() throws Exception {
        this.registeredService.setLogoutUrl(new URL("https://www.apereo.org"));
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)logoutRequest.getLogoutUrl(), (Object)this.registeredService.getLogoutUrl());
    }

    @Test
    public void verifyLogoutDisabled() {
        this.logoutManager = new DefaultLogoutManager((LogoutMessageCreator)new SamlCompliantLogoutMessageCreator(), (SingleLogoutServiceMessageHandler)this.singleLogoutServiceMessageHandler, true, (LogoutExecutionPlan)Mockito.mock(LogoutExecutionPlan.class));
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)0L, (long)logoutRequests.size());
    }

    @Test
    public void verifyLogoutAlreadyLoggedOut() {
        this.simpleWebApplicationServiceImpl.setLoggedOutAlready(true);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)0L, (long)logoutRequests.size());
    }

    @Test
    public void verifyLogoutTypeNotSet() {
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assert.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assert.assertEquals((Object)LogoutRequestStatus.SUCCESS, (Object)logoutRequest.getStatus());
    }

    @Test
    public void verifyLogoutTypeBack() {
        this.registeredService.setLogoutType(RegisteredService.LogoutType.BACK_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assert.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assert.assertEquals((Object)LogoutRequestStatus.SUCCESS, (Object)logoutRequest.getStatus());
    }

    @Test
    public void verifyLogoutTypeNone() {
        this.registeredService.setLogoutType(RegisteredService.LogoutType.NONE);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)0L, (long)logoutRequests.size());
    }

    @Test
    public void verifyLogoutTypeNull() {
        this.registeredService.setLogoutType(null);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
    }

    @Test
    public void verifyLogoutTypeFront() {
        this.registeredService.setLogoutType(RegisteredService.LogoutType.FRONT_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assert.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assert.assertEquals((Object)LogoutRequestStatus.NOT_ATTEMPTED, (Object)logoutRequest.getStatus());
    }

    @Test
    public void verifyAsynchronousLogout() {
        this.registeredService.setLogoutType(RegisteredService.LogoutType.BACK_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
    }
}

