/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.net.URL;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.web.SimpleUrlValidatorFactoryBean;
import org.apereo.cas.web.UrlValidator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultSingleLogoutServiceLogoutUrlBuilderTests {
    @Test
    public void verifyLogoutUrlByService() throws Exception {
        AbstractRegisteredService svc = RegisteredServiceTestUtils.getRegisteredService((String)"https://www.google.com");
        svc.setLogoutUrl(new URL("http://www.example.com/logout"));
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false);
        URL url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)RegisteredServiceTestUtils.getService((String)"https://www.google.com"));
        Assert.assertEquals((Object)url, (Object)svc.getLogoutUrl());
    }

    @Test
    public void verifyLogoutUrlByDefault() throws Exception {
        AbstractRegisteredService svc = RegisteredServiceTestUtils.getRegisteredService((String)".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false);
        URL url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)RegisteredServiceTestUtils.getService((String)"https://www.somewhere.com/logout?p=v"));
        Assert.assertEquals((Object)url, (Object)new URL("https://www.somewhere.com/logout?p=v"));
    }

    @Test
    public void verifyLogoutUrlUnknownUrlProtocol() throws Exception {
        AbstractRegisteredService svc = RegisteredServiceTestUtils.getRegisteredService((String)".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false);
        URL url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)RegisteredServiceTestUtils.getService((String)"imaps://etc.example.org"));
        Assert.assertNull((Object)url);
    }

    @Test
    public void verifyLocalLogoutUrlWithLocalUrlNotAllowed() throws Exception {
        AbstractRegisteredService svc = RegisteredServiceTestUtils.getRegisteredService((String)".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false);
        URL url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)RegisteredServiceTestUtils.getService((String)"https://localhost/logout?p=v"));
        Assert.assertNull((Object)url);
    }

    @Test
    public void verifyLocalLogoutUrlWithLocalUrlAllowed() throws Exception {
        AbstractRegisteredService svc = RegisteredServiceTestUtils.getRegisteredService((String)".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(true);
        URL url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)RegisteredServiceTestUtils.getService((String)"https://localhost/logout?p=v"));
        Assert.assertEquals((Object)url, (Object)new URL("https://localhost/logout?p=v"));
    }

    private DefaultSingleLogoutServiceLogoutUrlBuilder createDefaultSingleLogoutServiceLogoutUrlBuilder(boolean allowLocalLogoutUrls) throws Exception {
        UrlValidator validator = new SimpleUrlValidatorFactoryBean(allowLocalLogoutUrls).getObject();
        return new DefaultSingleLogoutServiceLogoutUrlBuilder(validator);
    }
}

