/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.io.ByteArrayInputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.DefaultLogoutRequest;
import org.apereo.cas.logout.LogoutMessageCreator;
import org.apereo.cas.logout.LogoutRequest;
import org.apereo.cas.logout.SamlCompliantLogoutMessageCreator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@RunWith(value=JUnit4.class)
public class SamlCompliantLogoutMessageCreatorTests {
    private final LogoutMessageCreator builder = new SamlCompliantLogoutMessageCreator();

    @Test
    public void verifyMessageBuilding() throws Exception {
        WebApplicationService service = (WebApplicationService)Mockito.mock(WebApplicationService.class);
        Mockito.when((Object)service.getOriginalUrl()).thenReturn((Object)"https://google.com");
        URL logoutUrl = new URL(service.getOriginalUrl());
        DefaultLogoutRequest request = new DefaultLogoutRequest("TICKET-ID", service, logoutUrl);
        String msg = this.builder.create((LogoutRequest)request);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(msg.getBytes());
        Document document = builder.parse(is);
        NodeList list = document.getDocumentElement().getElementsByTagName("samlp:SessionIndex");
        Assert.assertEquals((long)list.getLength(), (long)1L);
        Assert.assertEquals((Object)list.item(0).getTextContent(), (Object)request.getTicketId());
    }
}

