/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.net.URL;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.logout.DefaultLogoutExecutionPlan;
import org.apereo.cas.logout.DefaultLogoutManager;
import org.apereo.cas.logout.DefaultSingleLogoutMessageCreator;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceMessageHandler;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequest;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpMessage;
import org.apereo.cas.web.SimpleUrlValidatorFactoryBean;
import org.apereo.cas.web.UrlValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="Simple")
public class DefaultLogoutManagerTests {
    private static final String ID = "id";
    private static final String URL = "http://www.github.com";
    private LogoutManager logoutManager;
    private TicketGrantingTicket tgt;
    private AbstractWebApplicationService simpleWebApplicationServiceImpl;
    private AbstractRegisteredService registeredService;
    @Mock
    private ServicesManager servicesManager;
    @Mock
    private HttpClient client;
    private DefaultSingleLogoutServiceMessageHandler singleLogoutServiceMessageHandler;

    public DefaultLogoutManagerTests() {
        MockitoAnnotations.initMocks((Object)this);
    }

    public static AbstractRegisteredService getRegisteredService(String id) {
        RegexRegisteredService s = new RegexRegisteredService();
        s.setServiceId(id);
        s.setName("Test registered service " + id);
        s.setDescription("Registered service description");
        s.setProxyPolicy((RegisteredServiceProxyPolicy)new RegexMatchingRegisteredServiceProxyPolicy("^https?://.+"));
        s.setId((long)RandomUtils.getNativeInstance().nextInt());
        return s;
    }

    public static AbstractWebApplicationService getService(String url) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("service", url);
        return (AbstractWebApplicationService)new WebApplicationServiceFactory().createService((HttpServletRequest)request);
    }

    @BeforeEach
    public void initialize() {
        this.tgt = new MockTicketGrantingTicket("casuser");
        Mockito.when((Object)this.client.isValidEndPoint((String)Mockito.any(String.class))).thenReturn((Object)true);
        Mockito.when((Object)this.client.isValidEndPoint((URL)Mockito.any(URL.class))).thenReturn((Object)true);
        Mockito.when((Object)this.client.sendMessageToEndPoint((HttpMessage)Mockito.any(HttpMessage.class))).thenReturn((Object)true);
        UrlValidator validator = new SimpleUrlValidatorFactoryBean(true).getObject();
        this.singleLogoutServiceMessageHandler = new DefaultSingleLogoutServiceMessageHandler(this.client, (SingleLogoutMessageCreator)new DefaultSingleLogoutMessageCreator(), this.servicesManager, (SingleLogoutServiceLogoutUrlBuilder)new DefaultSingleLogoutServiceLogoutUrlBuilder(validator), true, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        this.simpleWebApplicationServiceImpl = DefaultLogoutManagerTests.getService(URL);
        this.tgt.getServices().put(ID, this.simpleWebApplicationServiceImpl);
        DefaultLogoutExecutionPlan plan = new DefaultLogoutExecutionPlan();
        plan.registerSingleLogoutServiceMessageHandler((SingleLogoutServiceMessageHandler)this.singleLogoutServiceMessageHandler);
        this.logoutManager = new DefaultLogoutManager(false, (LogoutExecutionPlan)plan);
        this.registeredService = DefaultLogoutManagerTests.getRegisteredService(URL);
        Mockito.when((Object)this.servicesManager.findServiceBy((Service)this.simpleWebApplicationServiceImpl)).thenReturn((Object)this.registeredService);
    }

    @Test
    public void verifyServiceLogoutUrlIsUsed() {
        this.registeredService.setLogoutUrl("https://www.apereo.org");
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        SingleLogoutRequest logoutRequest = (SingleLogoutRequest)logoutRequests.iterator().next();
        Assertions.assertEquals((Object)this.registeredService.getLogoutUrl(), (Object)logoutRequest.getLogoutUrl().toExternalForm());
    }

    @Test
    public void verifyLogoutDisabled() {
        DefaultLogoutExecutionPlan plan = new DefaultLogoutExecutionPlan();
        plan.registerSingleLogoutServiceMessageHandler((SingleLogoutServiceMessageHandler)this.singleLogoutServiceMessageHandler);
        this.logoutManager = new DefaultLogoutManager(true, (LogoutExecutionPlan)plan);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assertions.assertEquals((int)0, (int)logoutRequests.size());
    }

    @Test
    public void verifyLogoutAlreadyLoggedOut() {
        this.simpleWebApplicationServiceImpl.setLoggedOutAlready(true);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assertions.assertEquals((int)0, (int)logoutRequests.size());
    }

    @Test
    public void verifyLogoutTypeNotSet() {
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assertions.assertEquals((int)1, (int)logoutRequests.size());
        SingleLogoutRequest logoutRequest = (SingleLogoutRequest)logoutRequests.iterator().next();
        Assertions.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assertions.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assertions.assertEquals((Object)LogoutRequestStatus.SUCCESS, (Object)logoutRequest.getStatus());
    }

    @Test
    public void verifyLogoutTypeBack() {
        this.registeredService.setLogoutType(RegisteredServiceLogoutType.BACK_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assertions.assertEquals((int)1, (int)logoutRequests.size());
        SingleLogoutRequest logoutRequest = (SingleLogoutRequest)logoutRequests.iterator().next();
        Assertions.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assertions.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assertions.assertEquals((Object)LogoutRequestStatus.SUCCESS, (Object)logoutRequest.getStatus());
    }

    @Test
    public void verifyLogoutTypeNone() {
        this.registeredService.setLogoutType(RegisteredServiceLogoutType.NONE);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assertions.assertEquals((int)0, (int)logoutRequests.size());
    }

    @Test
    public void verifyLogoutTypeNull() {
        this.registeredService.setLogoutType(null);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assertions.assertEquals((int)1, (int)logoutRequests.size());
        SingleLogoutRequest logoutRequest = (SingleLogoutRequest)logoutRequests.iterator().next();
        Assertions.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
    }

    @Test
    public void verifyLogoutTypeFront() {
        this.registeredService.setLogoutType(RegisteredServiceLogoutType.FRONT_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assertions.assertEquals((int)1, (int)logoutRequests.size());
        SingleLogoutRequest logoutRequest = (SingleLogoutRequest)logoutRequests.iterator().next();
        Assertions.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assertions.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assertions.assertEquals((Object)LogoutRequestStatus.NOT_ATTEMPTED, (Object)logoutRequest.getStatus());
    }

    @Test
    public void verifyAsynchronousLogout() {
        this.registeredService.setLogoutType(RegisteredServiceLogoutType.BACK_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assertions.assertEquals((int)1, (int)logoutRequests.size());
    }
}

