/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.DefaultSingleLogoutMessageCreator;
import org.apereo.cas.logout.DefaultSingleLogoutRequest;
import org.apereo.cas.logout.slo.SingleLogoutMessage;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequest;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Tag(value="SAML")
public class SamlCompliantLogoutMessageCreatorTests {
    private static final String CONST_TEST_URL = "https://google.com";
    private final SingleLogoutMessageCreator builder = new DefaultSingleLogoutMessageCreator();

    @Test
    public void verifyMessageBuilding() throws Exception {
        WebApplicationService service = (WebApplicationService)Mockito.mock(WebApplicationService.class);
        Mockito.when((Object)service.getOriginalUrl()).thenReturn((Object)CONST_TEST_URL);
        URL logoutUrl = new URL(service.getOriginalUrl());
        DefaultSingleLogoutRequest request = DefaultSingleLogoutRequest.builder().ticketId("TICKET-ID").service(service).logoutUrl(logoutUrl).registeredService((RegisteredService)Mockito.mock(RegisteredService.class)).ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket("casuser")).build();
        SingleLogoutMessage msg = this.builder.create((SingleLogoutRequest)request);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        try (ByteArrayInputStream is = new ByteArrayInputStream(msg.getPayload().getBytes(StandardCharsets.UTF_8));){
            Document document = documentBuilder.parse(is);
            NodeList list = document.getDocumentElement().getElementsByTagName("samlp:SessionIndex");
            Assertions.assertEquals((int)1, (int)list.getLength());
            Assertions.assertEquals((Object)list.item(0).getTextContent(), (Object)request.getTicketId());
        }
    }
}

