/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout.config;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.DefaultLogoutExecutionPlan;
import org.apereo.cas.logout.DefaultLogoutManager;
import org.apereo.cas.logout.DefaultSingleLogoutMessageCreator;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceMessageHandler;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.web.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreLogoutConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreLogoutConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreLogoutConfiguration.class);
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="noRedirectHttpClient")
    private ObjectProvider<HttpClient> httpClient;
    @Autowired
    @Qualifier(value="urlValidator")
    private ObjectProvider<UrlValidator> urlValidator;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;

    @ConditionalOnMissingBean(name={"singleLogoutServiceLogoutUrlBuilder"})
    @Bean
    public SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder() {
        return new DefaultSingleLogoutServiceLogoutUrlBuilder((UrlValidator)this.urlValidator.getObject());
    }

    @ConditionalOnMissingBean(name={"defaultSingleLogoutServiceMessageHandler"})
    @Bean
    public SingleLogoutServiceMessageHandler defaultSingleLogoutServiceMessageHandler() {
        return new DefaultSingleLogoutServiceMessageHandler((HttpClient)this.httpClient.getObject(), this.defaultSingleLogoutMessageCreator(), (ServicesManager)this.servicesManager.getObject(), this.singleLogoutServiceLogoutUrlBuilder(), this.casProperties.getSlo().isAsynchronous(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject());
    }

    @ConditionalOnMissingBean(name={"logoutManager"})
    @RefreshScope
    @Autowired
    @Bean
    public LogoutManager logoutManager(@Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
        return new DefaultLogoutManager(this.casProperties.getSlo().isDisabled(), logoutExecutionPlan);
    }

    @ConditionalOnMissingBean(name={"defaultSingleLogoutMessageCreator"})
    @Bean
    public SingleLogoutMessageCreator defaultSingleLogoutMessageCreator() {
        return new DefaultSingleLogoutMessageCreator();
    }

    @ConditionalOnMissingBean(name={"logoutExecutionPlan"})
    @Autowired
    @Bean
    public LogoutExecutionPlan logoutExecutionPlan(List<LogoutExecutionPlanConfigurer> configurers) {
        DefaultLogoutExecutionPlan plan = new DefaultLogoutExecutionPlan();
        configurers.forEach(c -> {
            LOGGER.trace("Configuring logout execution plan [{}]", (Object)c.getName());
            c.configureLogoutExecutionPlan((LogoutExecutionPlan)plan);
        });
        return plan;
    }

    @Bean
    public LogoutExecutionPlanConfigurer casCoreLogoutExecutionPlanConfigurer() {
        return plan -> {
            plan.registerSingleLogoutServiceMessageHandler(this.defaultSingleLogoutServiceMessageHandler());
            if (this.casProperties.getLogout().isRemoveDescendantTickets()) {
                LOGGER.debug("CAS is configured to remove descendant tickets of the ticket-granting tickets");
                plan.registerLogoutPostProcessor(ticketGrantingTicket -> ticketGrantingTicket.getDescendantTickets().forEach(t -> {
                    LOGGER.debug("Deleting ticket [{}] from the registry as a descendant of [{}]", t, (Object)ticketGrantingTicket.getId());
                    ((TicketRegistry)this.ticketRegistry.getObject()).deleteTicket(t);
                }));
            }
        };
    }
}

