/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.slo.ChainingSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.DefaultServicesManager;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.web.SimpleUrlValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="Logout")
public class ChainingSingleLogoutServiceLogoutUrlBuilderTests {
    private ServicesManager servicesManager;

    @BeforeEach
    public void beforeEach() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().serviceRegistry((ServiceRegistry)new InMemoryServiceRegistry((ConfigurableApplicationContext)appCtx)).applicationContext((ConfigurableApplicationContext)appCtx).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        this.servicesManager = new DefaultServicesManager(context);
    }

    @Test
    public void verifyOperation() {
        ChainingSingleLogoutServiceLogoutUrlBuilder builder = new ChainingSingleLogoutServiceLogoutUrlBuilder(List.of(new DefaultSingleLogoutServiceLogoutUrlBuilder(this.servicesManager, SimpleUrlValidator.getInstance())));
        WebApplicationService service = CoreAuthenticationTestUtils.getWebApplicationService();
        RegexRegisteredService registeredService = (RegexRegisteredService)Mockito.mock(RegexRegisteredService.class);
        Mockito.when((Object)registeredService.matches((Service)Mockito.any(Service.class))).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)registeredService.getFriendlyName()).thenCallRealMethod();
        Mockito.when((Object)registeredService.getServiceId()).thenReturn((Object)"https://google.com");
        Mockito.when((Object)registeredService.matches(Mockito.anyString())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)registeredService.getAccessStrategy()).thenReturn((Object)new DefaultRegisteredServiceAccessStrategy());
        Mockito.when((Object)registeredService.getLogoutUrl()).thenReturn((Object)"https://somewhere.org");
        this.servicesManager.save((RegisteredService)registeredService);
        Assertions.assertTrue((boolean)builder.supports((RegisteredService)registeredService, service, Optional.empty()));
        Assertions.assertTrue((boolean)builder.isServiceAuthorized(service, Optional.empty()));
        Assertions.assertFalse((boolean)builder.determineLogoutUrl((RegisteredService)registeredService, service, Optional.empty()).isEmpty());
    }
}

