/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.util.Optional;
import java.util.UUID;
import org.apereo.cas.logout.DefaultSingleLogoutMessageCreator;
import org.apereo.cas.logout.SingleLogoutExecutionRequest;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="Logout")
public class DefaultSingleLogoutMessageCreatorTests {
    @Test
    public void verifyFrontChannel() {
        DefaultSingleLogoutMessageCreator input = new DefaultSingleLogoutMessageCreator();
        SingleLogoutExecutionRequest exec = SingleLogoutExecutionRequest.builder().ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket("casuser")).httpServletRequest(Optional.of(new MockHttpServletRequest())).build();
        SingleLogoutRequestContext request = (SingleLogoutRequestContext)Mockito.mock(SingleLogoutRequestContext.class);
        Mockito.when((Object)request.getExecutionRequest()).thenReturn((Object)exec);
        Mockito.when((Object)request.getTicketId()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)request.getLogoutType()).thenReturn((Object)RegisteredServiceLogoutType.FRONT_CHANNEL);
        Assertions.assertNotNull((Object)input.create(request));
    }
}

