/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutUrl;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.DefaultServicesManager;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.web.SimpleUrlValidatorFactoryBean;
import org.apereo.cas.web.UrlValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="Logout")
public class DefaultSingleLogoutServiceLogoutUrlBuilderTests {
    private ServicesManager servicesManager;

    public static AbstractWebApplicationService getService(String url) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("service", url);
        return (AbstractWebApplicationService)new WebApplicationServiceFactory().createService((HttpServletRequest)request);
    }

    public AbstractRegisteredService getRegisteredService(String id) {
        RegexRegisteredService s = new RegexRegisteredService();
        s.setServiceId(id);
        s.setName("Test service " + id);
        s.setDescription("Registered service description");
        s.setProxyPolicy((RegisteredServiceProxyPolicy)new RegexMatchingRegisteredServiceProxyPolicy("^https?://.+"));
        s.setId((long)RandomUtils.getNativeInstance().nextInt());
        this.servicesManager.save((RegisteredService)s);
        return s;
    }

    @BeforeEach
    public void beforeEach() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().serviceRegistry((ServiceRegistry)new InMemoryServiceRegistry((ConfigurableApplicationContext)appCtx)).applicationContext((ConfigurableApplicationContext)appCtx).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        this.servicesManager = new DefaultServicesManager(context);
    }

    @Test
    public void verifyLogoutUrlByService() {
        AbstractRegisteredService svc = this.getRegisteredService("https://www.google.com");
        svc.setLogoutUrl("http://www.example.com/logout");
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false);
        Collection url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)DefaultSingleLogoutServiceLogoutUrlBuilderTests.getService("https://www.google.com"));
        Assertions.assertEquals((Object)((SingleLogoutUrl)url.iterator().next()).getUrl(), (Object)svc.getLogoutUrl());
    }

    @Test
    public void verifyLogoutUrlByDefault() throws Exception {
        AbstractRegisteredService svc = this.getRegisteredService(".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false);
        Collection url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)DefaultSingleLogoutServiceLogoutUrlBuilderTests.getService("https://www.somewhere.com/logout?p=v"));
        Assertions.assertEquals((Object)new URL("https://www.somewhere.com/logout?p=v").toExternalForm(), (Object)((SingleLogoutUrl)url.iterator().next()).getUrl());
    }

    @Test
    public void verifyLogoutUrlUnknownUrlProtocol() {
        AbstractRegisteredService svc = this.getRegisteredService(".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false);
        Collection url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)DefaultSingleLogoutServiceLogoutUrlBuilderTests.getService("imaps://etc.example.org"));
        Assertions.assertTrue((boolean)url.isEmpty());
    }

    @Test
    public void verifyLocalLogoutUrlWithLocalUrlNotAllowed() {
        AbstractRegisteredService svc = this.getRegisteredService(".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false);
        Collection url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)DefaultSingleLogoutServiceLogoutUrlBuilderTests.getService("https://localhost/logout?p=v"));
        Assertions.assertTrue((boolean)url.isEmpty());
    }

    @Test
    public void verifyLocalLogoutUrlWithLocalUrlAllowed() throws Exception {
        AbstractRegisteredService svc = this.getRegisteredService(".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(true);
        Collection url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)DefaultSingleLogoutServiceLogoutUrlBuilderTests.getService("https://localhost/logout?p=v"));
        Assertions.assertEquals((Object)new URL("https://localhost/logout?p=v").toExternalForm(), (Object)((SingleLogoutUrl)url.iterator().next()).getUrl());
    }

    @Test
    public void verifyLocalLogoutUrlWithValidRegExValidationAndLocalUrlNotAllowed() throws Exception {
        AbstractRegisteredService svc = this.getRegisteredService(".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false, "\\w*", true);
        Collection url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)DefaultSingleLogoutServiceLogoutUrlBuilderTests.getService("https://localhost/logout?p=v"));
        Assertions.assertEquals((Object)new URL("https://localhost/logout?p=v").toExternalForm(), (Object)((SingleLogoutUrl)url.iterator().next()).getUrl());
    }

    @Test
    public void verifyLocalLogoutUrlWithInvalidRegExValidationAndLocalUrlAllowed() throws Exception {
        AbstractRegisteredService svc = this.getRegisteredService(".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(true, "\\d*", true);
        Collection url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)DefaultSingleLogoutServiceLogoutUrlBuilderTests.getService("https://localhost/logout?p=v"));
        Assertions.assertEquals((Object)new URL("https://localhost/logout?p=v").toExternalForm(), (Object)((SingleLogoutUrl)url.iterator().next()).getUrl());
    }

    @Test
    public void verifyLocalLogoutUrlWithInvalidRegExValidationAndLocalUrlNotAllowed() {
        AbstractRegisteredService svc = this.getRegisteredService(".+");
        svc.setLogoutUrl(null);
        DefaultSingleLogoutServiceLogoutUrlBuilder builder = this.createDefaultSingleLogoutServiceLogoutUrlBuilder(false, "\\d*", true);
        Collection url = builder.determineLogoutUrl((RegisteredService)svc, (WebApplicationService)DefaultSingleLogoutServiceLogoutUrlBuilderTests.getService("https://localhost/logout?p=v"));
        Assertions.assertTrue((boolean)url.isEmpty());
    }

    private DefaultSingleLogoutServiceLogoutUrlBuilder createDefaultSingleLogoutServiceLogoutUrlBuilder(boolean allowLocalLogoutUrls) {
        return this.createDefaultSingleLogoutServiceLogoutUrlBuilder(allowLocalLogoutUrls, null, true);
    }

    private DefaultSingleLogoutServiceLogoutUrlBuilder createDefaultSingleLogoutServiceLogoutUrlBuilder(boolean allowLocalLogoutUrls, String authorityValidationRegEx, boolean authorityValidationRegExCaseSensitive) {
        UrlValidator validator = new SimpleUrlValidatorFactoryBean(allowLocalLogoutUrls, authorityValidationRegEx, authorityValidationRegExCaseSensitive).getObject();
        return new DefaultSingleLogoutServiceLogoutUrlBuilder(this.servicesManager, validator);
    }
}

