/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.core.logout.LogoutProperties;
import org.apereo.cas.logout.DefaultLogoutRedirectionStrategy;
import org.apereo.cas.logout.LogoutWebApplicationServiceFactory;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.util.MockServletContext;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="Logout")
public class DefaultLogoutRedirectionStrategyTests {
    private static MockRequestContext getMockRequestContext(MockHttpServletRequest request) {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        request.setRequestURI("/logout");
        return context;
    }

    @Test
    public void verifyNoRedirect() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/logout");
        MockRequestContext context = DefaultLogoutRedirectionStrategyTests.getMockRequestContext(request);
        LogoutProperties props = new LogoutProperties();
        props.setFollowServiceRedirects(true);
        DefaultArgumentExtractor extractor = new DefaultArgumentExtractor((ServiceFactory)new LogoutWebApplicationServiceFactory(props));
        DefaultLogoutRedirectionStrategy strategy = new DefaultLogoutRedirectionStrategy((ArgumentExtractor)extractor, props, (SingleLogoutServiceLogoutUrlBuilder)Mockito.mock(SingleLogoutServiceLogoutUrlBuilder.class));
        Assertions.assertTrue((boolean)strategy.supports((RequestContext)context));
        strategy.handle((RequestContext)context);
        Assertions.assertNull((Object)WebUtils.getLogoutRedirectUrl((RequestContext)context, String.class));
        WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)"https://github.com/apereo/cas");
        strategy.handle((RequestContext)context);
        Assertions.assertNotNull((Object)WebUtils.getLogoutRedirectUrl((RequestContext)context, String.class));
    }

    @Test
    public void verifyRedirectToTrustedUrl() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)"https://github.com/apereo/cas");
        MockRequestContext context = DefaultLogoutRedirectionStrategyTests.getMockRequestContext(request);
        LogoutProperties props = new LogoutProperties();
        props.setFollowServiceRedirects(true);
        DefaultArgumentExtractor extractor = new DefaultArgumentExtractor((ServiceFactory)new LogoutWebApplicationServiceFactory(props));
        DefaultLogoutRedirectionStrategy strategy = new DefaultLogoutRedirectionStrategy((ArgumentExtractor)extractor, props, (SingleLogoutServiceLogoutUrlBuilder)Mockito.mock(SingleLogoutServiceLogoutUrlBuilder.class));
        strategy.handle((RequestContext)context);
        Assertions.assertNotNull((Object)WebUtils.getLogoutRedirectUrl((RequestContext)context, String.class));
    }

    @Test
    public void verifyRedirectToService() {
        LogoutProperties props = new LogoutProperties();
        props.setFollowServiceRedirects(true);
        props.setRedirectParameter("targetParam");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/logout");
        request.addParameter(props.getRedirectParameter(), "https://github.com/apereo/cas");
        MockRequestContext context = DefaultLogoutRedirectionStrategyTests.getMockRequestContext(request);
        DefaultArgumentExtractor extractor = new DefaultArgumentExtractor((ServiceFactory)new LogoutWebApplicationServiceFactory(props));
        SingleLogoutServiceLogoutUrlBuilder logoutUrlBuilder = (SingleLogoutServiceLogoutUrlBuilder)Mockito.mock(SingleLogoutServiceLogoutUrlBuilder.class);
        Mockito.when((Object)logoutUrlBuilder.isServiceAuthorized((WebApplicationService)Mockito.any(WebApplicationService.class), (Optional)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        DefaultLogoutRedirectionStrategy strategy = new DefaultLogoutRedirectionStrategy((ArgumentExtractor)extractor, props, logoutUrlBuilder);
        strategy.handle((RequestContext)context);
        Assertions.assertNotNull((Object)WebUtils.getLogoutRedirectUrl((RequestContext)context, String.class));
    }

    @Test
    public void verifyRedirectToUnauthzService() {
        LogoutProperties props = new LogoutProperties();
        props.setFollowServiceRedirects(true);
        props.setRedirectParameter("targetParam");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/logout");
        request.addParameter(props.getRedirectParameter(), "https://github.com/apereo/cas");
        MockRequestContext context = DefaultLogoutRedirectionStrategyTests.getMockRequestContext(request);
        SingleLogoutServiceLogoutUrlBuilder logoutUrlBuilder = (SingleLogoutServiceLogoutUrlBuilder)Mockito.mock(SingleLogoutServiceLogoutUrlBuilder.class);
        DefaultArgumentExtractor extractor = new DefaultArgumentExtractor((ServiceFactory)new LogoutWebApplicationServiceFactory(props));
        DefaultLogoutRedirectionStrategy strategy = new DefaultLogoutRedirectionStrategy((ArgumentExtractor)extractor, props, logoutUrlBuilder);
        Mockito.when((Object)logoutUrlBuilder.isServiceAuthorized((WebApplicationService)Mockito.any(WebApplicationService.class), (Optional)Mockito.any())).thenReturn((Object)Boolean.FALSE);
        strategy.handle((RequestContext)context);
        Assertions.assertNull((Object)WebUtils.getLogoutRedirectUrl((RequestContext)context, String.class));
    }
}

