/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout.config;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.SingleLogoutExecutionRequest;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@SpringBootTest(classes={RefreshAutoConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreServicesConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreUtilConfiguration.class, CasCoreWebConfiguration.class, CasCoreHttpConfiguration.class, CasCookieConfiguration.class, CasCoreConfiguration.class, CasCoreNotificationsConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreLogoutConfiguration.class}, properties={"cas.logout.remove-descendant-tickets=true"})
@Tag(value="CasConfiguration")
public class CasCoreLogoutConfigurationTests {
    @Autowired
    @Qualifier(value="logoutManager")
    private LogoutManager logoutManager;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="casProtocolEndpointConfigurer")
    private ProtocolEndpointWebSecurityConfigurer<Void> casProtocolEndpointConfigurer;

    @Test
    public void verifyOperation() {
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)UUID.randomUUID().toString());
        AbstractRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService((String)service.getId());
        this.servicesManager.save((RegisteredService)registeredService);
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        ServiceTicket st = tgt.grantServiceTicket((Service)service);
        tgt.getDescendantTickets().add(st.getId());
        List results = this.logoutManager.performLogout(SingleLogoutExecutionRequest.builder().ticketGrantingTicket((TicketGrantingTicket)tgt).httpServletResponse(Optional.of(new MockHttpServletResponse())).httpServletRequest(Optional.of(new MockHttpServletRequest())).build());
        Assertions.assertFalse((boolean)results.isEmpty());
        Assertions.assertFalse((boolean)this.casProtocolEndpointConfigurer.getIgnoredEndpoints().isEmpty());
    }
}

