/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.rest.factory;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.rest.factory.ChainingRestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Tag(value="Authentication")
public class ChainingRestHttpRequestCredentialFactoryTests {
    @Test
    public void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.put((Object)"username", List.of("casuser"));
        body.put((Object)"password", List.of("Mellon"));
        ChainingRestHttpRequestCredentialFactory factory = new ChainingRestHttpRequestCredentialFactory(new RestHttpRequestCredentialFactory[]{new UsernamePasswordRestHttpRequestCredentialFactory()});
        Assertions.assertNotNull((Object)factory.fromRequest((HttpServletRequest)request, (MultiValueMap)body));
        Assertions.assertTrue((boolean)factory.fromAuthentication((HttpServletRequest)request, (MultiValueMap)body, CoreAuthenticationTestUtils.getAuthentication(), (MultifactorAuthenticationProvider)Mockito.mock(MultifactorAuthenticationProvider.class)).isEmpty());
    }

    @Test
    public void verifyDefaultImpl() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        RestHttpRequestCredentialFactory factory = (RestHttpRequestCredentialFactory)Mockito.mock(RestHttpRequestCredentialFactory.class);
        Mockito.when((Object)factory.fromAuthentication((HttpServletRequest)Mockito.any(), (MultiValueMap)Mockito.any(), (Authentication)Mockito.any(), (MultifactorAuthenticationProvider)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)factory.getOrder()).thenCallRealMethod();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)factory.getOrder());
        Assertions.assertTrue((boolean)factory.fromAuthentication((HttpServletRequest)request, (MultiValueMap)body, CoreAuthenticationTestUtils.getAuthentication(), (MultifactorAuthenticationProvider)Mockito.mock(MultifactorAuthenticationProvider.class)).isEmpty());
    }
}

