/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.util;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.services.RegisteredServicePublicKeyImpl;
import org.apereo.cas.services.util.RegisteredServicePublicKeyCipherExecutor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServicePublicKeyCipherExecutorTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServicePublicKeyCipherExecutorTests.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void verifyCipherUnableToEncodeForStringIsTooLong() {
        AbstractRegisteredService svc = this.getService("classpath:keys/RSA1024Public.key");
        String ticketId = RandomStringUtils.randomAlphanumeric((int)120);
        RegisteredServicePublicKeyCipherExecutor e = new RegisteredServicePublicKeyCipherExecutor();
        Assert.assertNull((Object)e.encode(ticketId, Optional.of(svc)));
    }

    @Test
    public void verifyCipherAbleToEncode() {
        AbstractRegisteredService svc = this.getService("classpath:keys/RSA4096Public.key");
        String ticketId = RandomStringUtils.randomAlphanumeric((int)120);
        RegisteredServicePublicKeyCipherExecutor e = new RegisteredServicePublicKeyCipherExecutor();
        Assert.assertNotNull((Object)e.encode(ticketId, Optional.of(svc)));
    }

    private AbstractRegisteredService getService(String keyLocation) {
        RegexRegisteredService svc = new RegexRegisteredService();
        svc.setServiceId("Testing");
        svc.setPublicKey((RegisteredServicePublicKey)new RegisteredServicePublicKeyImpl(keyLocation, "RSA"));
        return svc;
    }
}

