/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Inheritance;
import javax.persistence.Lob;
import javax.persistence.MapKeyColumn;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.DefaultRegisteredServiceContact;
import org.apereo.cas.services.DefaultRegisteredServiceExpirationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RefuseRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceContact;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.services.RegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.Id;

@Entity
@Inheritance
@DiscriminatorColumn(name="expression_type", length=50, discriminatorType=DiscriminatorType.STRING, columnDefinition="VARCHAR(50) DEFAULT 'regex'")
@Table(name="RegexRegisteredService")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AbstractRegisteredService
implements RegisteredService {
    private static final long serialVersionUID = 7645279151115635245L;
    @Column(nullable=false)
    protected String serviceId;
    @Column(nullable=false)
    private String name;
    @Column
    private String theme;
    @Column
    private String informationUrl;
    @Column
    private String privacyUrl;
    @Column
    private String responseType;
    @Id
    @javax.persistence.Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="native")
    @GenericGenerator(name="native", strategy="native")
    private long id = -1L;
    @Column
    private String description;
    @Lob
    @Column(name="expiration_policy", length=0x7FFFFFFF)
    private RegisteredServiceExpirationPolicy expirationPolicy = new DefaultRegisteredServiceExpirationPolicy();
    @Lob
    @Column(name="proxy_policy", length=0x7FFFFFFF)
    private RegisteredServiceProxyPolicy proxyPolicy = new RefuseRegisteredServiceProxyPolicy();
    @Lob
    @Column(name="proxy_ticket_expiration_policy", length=0x7FFFFFFF)
    private RegisteredServiceProxyTicketExpirationPolicy proxyTicketExpirationPolicy;
    @Lob
    @Column(name="service_ticket_expiration_policy", length=0x7FFFFFFF)
    private RegisteredServiceServiceTicketExpirationPolicy serviceTicketExpirationPolicy;
    @Lob
    @Column(name="sso_participation_policy", length=0x7FFFFFFF)
    private RegisteredServiceSingleSignOnParticipationPolicy singleSignOnParticipationPolicy;
    @Column(name="evaluation_order", nullable=false)
    private int evaluationOrder;
    @Lob
    @Column(name="username_attr", length=0x7FFFFFFF)
    private RegisteredServiceUsernameAttributeProvider usernameAttributeProvider = new DefaultRegisteredServiceUsernameProvider();
    @Column(name="logout_type")
    private RegisteredServiceLogoutType logoutType = RegisteredServiceLogoutType.BACK_CHANNEL;
    @Lob
    @Column(name="required_handlers", length=0x7FFFFFFF)
    private HashSet<String> requiredHandlers = new HashSet();
    @Lob
    @Column(name="environments", length=0x7FFFFFFF)
    private HashSet<String> environments = new HashSet();
    @Lob
    @Column(name="attribute_release", length=0x7FFFFFFF)
    private RegisteredServiceAttributeReleasePolicy attributeReleasePolicy = new ReturnAllowedAttributeReleasePolicy();
    @Lob
    @Column(name="mfa_policy", length=0x7FFFFFFF)
    private RegisteredServiceMultifactorPolicy multifactorPolicy = new DefaultRegisteredServiceMultifactorPolicy();
    @Column
    private String logo;
    @Column(name="logout_url")
    private String logoutUrl;
    @Lob
    @Column(name="access_strategy", length=0x7FFFFFFF)
    private RegisteredServiceAccessStrategy accessStrategy = new DefaultRegisteredServiceAccessStrategy();
    @Lob
    @Column(name="public_key", length=0x7FFFFFFF)
    private RegisteredServicePublicKey publicKey;
    @ElementCollection(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL})
    @CollectionTable(name="RegexRegisteredService_RegexRegisteredServiceProperty")
    @MapKeyColumn(name="RegexRegisteredServiceProperty_name")
    @Column(name="RegexRegisteredServiceProperty_value")
    private Map<String, DefaultRegisteredServiceProperty> properties = new HashMap<String, DefaultRegisteredServiceProperty>();
    @ElementCollection(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL})
    @CollectionTable(name="RegexRegisteredService_RegisteredServiceImplContact")
    @OrderColumn
    private List<DefaultRegisteredServiceContact> contacts = new ArrayList<DefaultRegisteredServiceContact>();

    public void initialize() {
        this.proxyPolicy = (RegisteredServiceProxyPolicy)ObjectUtils.defaultIfNull((Object)this.proxyPolicy, (Object)new RefuseRegisteredServiceProxyPolicy());
        this.usernameAttributeProvider = (RegisteredServiceUsernameAttributeProvider)ObjectUtils.defaultIfNull((Object)this.usernameAttributeProvider, (Object)new DefaultRegisteredServiceUsernameProvider());
        this.logoutType = (RegisteredServiceLogoutType)ObjectUtils.defaultIfNull((Object)this.logoutType, (Object)RegisteredServiceLogoutType.BACK_CHANNEL);
        this.requiredHandlers = (HashSet)ObjectUtils.defaultIfNull(this.requiredHandlers, new HashSet());
        this.accessStrategy = (RegisteredServiceAccessStrategy)ObjectUtils.defaultIfNull((Object)this.accessStrategy, (Object)new DefaultRegisteredServiceAccessStrategy());
        this.multifactorPolicy = (RegisteredServiceMultifactorPolicy)ObjectUtils.defaultIfNull((Object)this.multifactorPolicy, (Object)new DefaultRegisteredServiceMultifactorPolicy());
        this.properties = (Map)ObjectUtils.defaultIfNull(this.properties, new LinkedHashMap());
        this.attributeReleasePolicy = (RegisteredServiceAttributeReleasePolicy)ObjectUtils.defaultIfNull((Object)this.attributeReleasePolicy, (Object)new ReturnAllowedAttributeReleasePolicy());
        this.contacts = (List)ObjectUtils.defaultIfNull(this.contacts, new ArrayList());
        this.expirationPolicy = (RegisteredServiceExpirationPolicy)ObjectUtils.defaultIfNull((Object)this.expirationPolicy, (Object)new DefaultRegisteredServiceExpirationPolicy());
    }

    public abstract void setServiceId(String var1);

    public int compareTo(RegisteredService other) {
        return new CompareToBuilder().append(this.getEvaluationOrder(), other.getEvaluationOrder()).append((Object)((String)StringUtils.defaultIfBlank((CharSequence)this.getName(), (CharSequence)"")).toLowerCase(), (Object)((String)StringUtils.defaultIfBlank((CharSequence)other.getName(), (CharSequence)"")).toLowerCase()).append((Object)this.getServiceId(), (Object)other.getServiceId()).append(this.getId(), other.getId()).toComparison();
    }

    protected abstract AbstractRegisteredService newInstance();

    public Map<String, RegisteredServiceProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, RegisteredServiceProperty> properties) {
        this.properties = properties;
    }

    public List<RegisteredServiceContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<RegisteredServiceContact> contacts) {
        this.contacts = contacts;
    }

    @Generated
    public String toString() {
        return "AbstractRegisteredService(serviceId=" + this.serviceId + ", name=" + this.name + ", theme=" + this.theme + ", informationUrl=" + this.informationUrl + ", privacyUrl=" + this.privacyUrl + ", responseType=" + this.responseType + ", id=" + this.id + ", description=" + this.description + ", expirationPolicy=" + this.expirationPolicy + ", proxyPolicy=" + this.proxyPolicy + ", proxyTicketExpirationPolicy=" + this.proxyTicketExpirationPolicy + ", serviceTicketExpirationPolicy=" + this.serviceTicketExpirationPolicy + ", singleSignOnParticipationPolicy=" + this.singleSignOnParticipationPolicy + ", evaluationOrder=" + this.evaluationOrder + ", usernameAttributeProvider=" + this.usernameAttributeProvider + ", logoutType=" + this.logoutType + ", requiredHandlers=" + this.requiredHandlers + ", environments=" + this.environments + ", attributeReleasePolicy=" + this.attributeReleasePolicy + ", multifactorPolicy=" + this.multifactorPolicy + ", logo=" + this.logo + ", logoutUrl=" + this.logoutUrl + ", accessStrategy=" + this.accessStrategy + ", publicKey=" + this.publicKey + ", properties=" + this.properties + ", contacts=" + this.contacts + ")";
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTheme() {
        return this.theme;
    }

    @Generated
    public String getInformationUrl() {
        return this.informationUrl;
    }

    @Generated
    public String getPrivacyUrl() {
        return this.privacyUrl;
    }

    @Generated
    public String getResponseType() {
        return this.responseType;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public RegisteredServiceExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @Generated
    public RegisteredServiceProxyPolicy getProxyPolicy() {
        return this.proxyPolicy;
    }

    @Generated
    public RegisteredServiceProxyTicketExpirationPolicy getProxyTicketExpirationPolicy() {
        return this.proxyTicketExpirationPolicy;
    }

    @Generated
    public RegisteredServiceServiceTicketExpirationPolicy getServiceTicketExpirationPolicy() {
        return this.serviceTicketExpirationPolicy;
    }

    @Generated
    public RegisteredServiceSingleSignOnParticipationPolicy getSingleSignOnParticipationPolicy() {
        return this.singleSignOnParticipationPolicy;
    }

    @Generated
    public int getEvaluationOrder() {
        return this.evaluationOrder;
    }

    @Generated
    public RegisteredServiceUsernameAttributeProvider getUsernameAttributeProvider() {
        return this.usernameAttributeProvider;
    }

    @Generated
    public RegisteredServiceLogoutType getLogoutType() {
        return this.logoutType;
    }

    @Generated
    public HashSet<String> getRequiredHandlers() {
        return this.requiredHandlers;
    }

    @Generated
    public HashSet<String> getEnvironments() {
        return this.environments;
    }

    @Generated
    public RegisteredServiceAttributeReleasePolicy getAttributeReleasePolicy() {
        return this.attributeReleasePolicy;
    }

    @Generated
    public RegisteredServiceMultifactorPolicy getMultifactorPolicy() {
        return this.multifactorPolicy;
    }

    @Generated
    public String getLogo() {
        return this.logo;
    }

    @Generated
    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    @Generated
    public RegisteredServiceAccessStrategy getAccessStrategy() {
        return this.accessStrategy;
    }

    @Generated
    public RegisteredServicePublicKey getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Generated
    public void setInformationUrl(String informationUrl) {
        this.informationUrl = informationUrl;
    }

    @Generated
    public void setPrivacyUrl(String privacyUrl) {
        this.privacyUrl = privacyUrl;
    }

    @Generated
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setExpirationPolicy(RegisteredServiceExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }

    @Generated
    public void setProxyPolicy(RegisteredServiceProxyPolicy proxyPolicy) {
        this.proxyPolicy = proxyPolicy;
    }

    @Generated
    public void setProxyTicketExpirationPolicy(RegisteredServiceProxyTicketExpirationPolicy proxyTicketExpirationPolicy) {
        this.proxyTicketExpirationPolicy = proxyTicketExpirationPolicy;
    }

    @Generated
    public void setServiceTicketExpirationPolicy(RegisteredServiceServiceTicketExpirationPolicy serviceTicketExpirationPolicy) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
    }

    @Generated
    public void setSingleSignOnParticipationPolicy(RegisteredServiceSingleSignOnParticipationPolicy singleSignOnParticipationPolicy) {
        this.singleSignOnParticipationPolicy = singleSignOnParticipationPolicy;
    }

    @Generated
    public void setEvaluationOrder(int evaluationOrder) {
        this.evaluationOrder = evaluationOrder;
    }

    @Generated
    public void setUsernameAttributeProvider(RegisteredServiceUsernameAttributeProvider usernameAttributeProvider) {
        this.usernameAttributeProvider = usernameAttributeProvider;
    }

    @Generated
    public void setLogoutType(RegisteredServiceLogoutType logoutType) {
        this.logoutType = logoutType;
    }

    @Generated
    public void setRequiredHandlers(HashSet<String> requiredHandlers) {
        this.requiredHandlers = requiredHandlers;
    }

    @Generated
    public void setEnvironments(HashSet<String> environments) {
        this.environments = environments;
    }

    @Generated
    public void setAttributeReleasePolicy(RegisteredServiceAttributeReleasePolicy attributeReleasePolicy) {
        this.attributeReleasePolicy = attributeReleasePolicy;
    }

    @Generated
    public void setMultifactorPolicy(RegisteredServiceMultifactorPolicy multifactorPolicy) {
        this.multifactorPolicy = multifactorPolicy;
    }

    @Generated
    public void setLogo(String logo) {
        this.logo = logo;
    }

    @Generated
    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    @Generated
    public void setAccessStrategy(RegisteredServiceAccessStrategy accessStrategy) {
        this.accessStrategy = accessStrategy;
    }

    @Generated
    public void setPublicKey(RegisteredServicePublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractRegisteredService)) {
            return false;
        }
        AbstractRegisteredService other = (AbstractRegisteredService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceId = this.serviceId;
        String other$serviceId = other.serviceId;
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$theme = this.theme;
        String other$theme = other.theme;
        if (this$theme == null ? other$theme != null : !this$theme.equals(other$theme)) {
            return false;
        }
        String this$informationUrl = this.informationUrl;
        String other$informationUrl = other.informationUrl;
        if (this$informationUrl == null ? other$informationUrl != null : !this$informationUrl.equals(other$informationUrl)) {
            return false;
        }
        String this$privacyUrl = this.privacyUrl;
        String other$privacyUrl = other.privacyUrl;
        if (this$privacyUrl == null ? other$privacyUrl != null : !this$privacyUrl.equals(other$privacyUrl)) {
            return false;
        }
        String this$responseType = this.responseType;
        String other$responseType = other.responseType;
        if (this$responseType == null ? other$responseType != null : !this$responseType.equals(other$responseType)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        RegisteredServiceExpirationPolicy this$expirationPolicy = this.expirationPolicy;
        RegisteredServiceExpirationPolicy other$expirationPolicy = other.expirationPolicy;
        if (this$expirationPolicy == null ? other$expirationPolicy != null : !this$expirationPolicy.equals(other$expirationPolicy)) {
            return false;
        }
        RegisteredServiceProxyPolicy this$proxyPolicy = this.proxyPolicy;
        RegisteredServiceProxyPolicy other$proxyPolicy = other.proxyPolicy;
        if (this$proxyPolicy == null ? other$proxyPolicy != null : !this$proxyPolicy.equals(other$proxyPolicy)) {
            return false;
        }
        RegisteredServiceProxyTicketExpirationPolicy this$proxyTicketExpirationPolicy = this.proxyTicketExpirationPolicy;
        RegisteredServiceProxyTicketExpirationPolicy other$proxyTicketExpirationPolicy = other.proxyTicketExpirationPolicy;
        if (this$proxyTicketExpirationPolicy == null ? other$proxyTicketExpirationPolicy != null : !this$proxyTicketExpirationPolicy.equals(other$proxyTicketExpirationPolicy)) {
            return false;
        }
        RegisteredServiceServiceTicketExpirationPolicy this$serviceTicketExpirationPolicy = this.serviceTicketExpirationPolicy;
        RegisteredServiceServiceTicketExpirationPolicy other$serviceTicketExpirationPolicy = other.serviceTicketExpirationPolicy;
        if (this$serviceTicketExpirationPolicy == null ? other$serviceTicketExpirationPolicy != null : !this$serviceTicketExpirationPolicy.equals(other$serviceTicketExpirationPolicy)) {
            return false;
        }
        RegisteredServiceSingleSignOnParticipationPolicy this$singleSignOnParticipationPolicy = this.singleSignOnParticipationPolicy;
        RegisteredServiceSingleSignOnParticipationPolicy other$singleSignOnParticipationPolicy = other.singleSignOnParticipationPolicy;
        if (this$singleSignOnParticipationPolicy == null ? other$singleSignOnParticipationPolicy != null : !this$singleSignOnParticipationPolicy.equals(other$singleSignOnParticipationPolicy)) {
            return false;
        }
        if (this.evaluationOrder != other.evaluationOrder) {
            return false;
        }
        RegisteredServiceUsernameAttributeProvider this$usernameAttributeProvider = this.usernameAttributeProvider;
        RegisteredServiceUsernameAttributeProvider other$usernameAttributeProvider = other.usernameAttributeProvider;
        if (this$usernameAttributeProvider == null ? other$usernameAttributeProvider != null : !this$usernameAttributeProvider.equals(other$usernameAttributeProvider)) {
            return false;
        }
        RegisteredServiceLogoutType this$logoutType = this.logoutType;
        RegisteredServiceLogoutType other$logoutType = other.logoutType;
        if (this$logoutType == null ? other$logoutType != null : !this$logoutType.equals(other$logoutType)) {
            return false;
        }
        HashSet<String> this$requiredHandlers = this.requiredHandlers;
        HashSet<String> other$requiredHandlers = other.requiredHandlers;
        if (this$requiredHandlers == null ? other$requiredHandlers != null : !((Object)this$requiredHandlers).equals(other$requiredHandlers)) {
            return false;
        }
        HashSet<String> this$environments = this.environments;
        HashSet<String> other$environments = other.environments;
        if (this$environments == null ? other$environments != null : !((Object)this$environments).equals(other$environments)) {
            return false;
        }
        RegisteredServiceAttributeReleasePolicy this$attributeReleasePolicy = this.attributeReleasePolicy;
        RegisteredServiceAttributeReleasePolicy other$attributeReleasePolicy = other.attributeReleasePolicy;
        if (this$attributeReleasePolicy == null ? other$attributeReleasePolicy != null : !this$attributeReleasePolicy.equals(other$attributeReleasePolicy)) {
            return false;
        }
        RegisteredServiceMultifactorPolicy this$multifactorPolicy = this.multifactorPolicy;
        RegisteredServiceMultifactorPolicy other$multifactorPolicy = other.multifactorPolicy;
        if (this$multifactorPolicy == null ? other$multifactorPolicy != null : !this$multifactorPolicy.equals(other$multifactorPolicy)) {
            return false;
        }
        String this$logo = this.logo;
        String other$logo = other.logo;
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        String this$logoutUrl = this.logoutUrl;
        String other$logoutUrl = other.logoutUrl;
        if (this$logoutUrl == null ? other$logoutUrl != null : !this$logoutUrl.equals(other$logoutUrl)) {
            return false;
        }
        RegisteredServiceAccessStrategy this$accessStrategy = this.accessStrategy;
        RegisteredServiceAccessStrategy other$accessStrategy = other.accessStrategy;
        if (this$accessStrategy == null ? other$accessStrategy != null : !this$accessStrategy.equals(other$accessStrategy)) {
            return false;
        }
        RegisteredServicePublicKey this$publicKey = this.publicKey;
        RegisteredServicePublicKey other$publicKey = other.publicKey;
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        Map<String, DefaultRegisteredServiceProperty> this$properties = this.properties;
        Map<String, DefaultRegisteredServiceProperty> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<DefaultRegisteredServiceContact> this$contacts = this.contacts;
        List<DefaultRegisteredServiceContact> other$contacts = other.contacts;
        return !(this$contacts == null ? other$contacts != null : !((Object)this$contacts).equals(other$contacts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractRegisteredService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceId = this.serviceId;
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $theme = this.theme;
        result = result * 59 + ($theme == null ? 43 : $theme.hashCode());
        String $informationUrl = this.informationUrl;
        result = result * 59 + ($informationUrl == null ? 43 : $informationUrl.hashCode());
        String $privacyUrl = this.privacyUrl;
        result = result * 59 + ($privacyUrl == null ? 43 : $privacyUrl.hashCode());
        String $responseType = this.responseType;
        result = result * 59 + ($responseType == null ? 43 : $responseType.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        RegisteredServiceExpirationPolicy $expirationPolicy = this.expirationPolicy;
        result = result * 59 + ($expirationPolicy == null ? 43 : $expirationPolicy.hashCode());
        RegisteredServiceProxyPolicy $proxyPolicy = this.proxyPolicy;
        result = result * 59 + ($proxyPolicy == null ? 43 : $proxyPolicy.hashCode());
        RegisteredServiceProxyTicketExpirationPolicy $proxyTicketExpirationPolicy = this.proxyTicketExpirationPolicy;
        result = result * 59 + ($proxyTicketExpirationPolicy == null ? 43 : $proxyTicketExpirationPolicy.hashCode());
        RegisteredServiceServiceTicketExpirationPolicy $serviceTicketExpirationPolicy = this.serviceTicketExpirationPolicy;
        result = result * 59 + ($serviceTicketExpirationPolicy == null ? 43 : $serviceTicketExpirationPolicy.hashCode());
        RegisteredServiceSingleSignOnParticipationPolicy $singleSignOnParticipationPolicy = this.singleSignOnParticipationPolicy;
        result = result * 59 + ($singleSignOnParticipationPolicy == null ? 43 : $singleSignOnParticipationPolicy.hashCode());
        result = result * 59 + this.evaluationOrder;
        RegisteredServiceUsernameAttributeProvider $usernameAttributeProvider = this.usernameAttributeProvider;
        result = result * 59 + ($usernameAttributeProvider == null ? 43 : $usernameAttributeProvider.hashCode());
        RegisteredServiceLogoutType $logoutType = this.logoutType;
        result = result * 59 + ($logoutType == null ? 43 : $logoutType.hashCode());
        HashSet<String> $requiredHandlers = this.requiredHandlers;
        result = result * 59 + ($requiredHandlers == null ? 43 : ((Object)$requiredHandlers).hashCode());
        HashSet<String> $environments = this.environments;
        result = result * 59 + ($environments == null ? 43 : ((Object)$environments).hashCode());
        RegisteredServiceAttributeReleasePolicy $attributeReleasePolicy = this.attributeReleasePolicy;
        result = result * 59 + ($attributeReleasePolicy == null ? 43 : $attributeReleasePolicy.hashCode());
        RegisteredServiceMultifactorPolicy $multifactorPolicy = this.multifactorPolicy;
        result = result * 59 + ($multifactorPolicy == null ? 43 : $multifactorPolicy.hashCode());
        String $logo = this.logo;
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        String $logoutUrl = this.logoutUrl;
        result = result * 59 + ($logoutUrl == null ? 43 : $logoutUrl.hashCode());
        RegisteredServiceAccessStrategy $accessStrategy = this.accessStrategy;
        result = result * 59 + ($accessStrategy == null ? 43 : $accessStrategy.hashCode());
        RegisteredServicePublicKey $publicKey = this.publicKey;
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        Map<String, DefaultRegisteredServiceProperty> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<DefaultRegisteredServiceContact> $contacts = this.contacts;
        result = result * 59 + ($contacts == null ? 43 : ((Object)$contacts).hashCode());
        return result;
    }
}

