/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apereo.cas.services.RegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.ticket.TicketState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public abstract class BaseDateTimeRegisteredServiceSingleSignOnParticipationPolicy
implements RegisteredServiceSingleSignOnParticipationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDateTimeRegisteredServiceSingleSignOnParticipationPolicy.class);
    private static final long serialVersionUID = -5923946898337761319L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private long timeValue;
    private int order;

    public boolean shouldParticipateInSso(TicketState ticketState) {
        LOGGER.trace("Calculating SSO participation criteria for [{}]", (Object)ticketState);
        if (this.timeValue <= 0L) {
            return true;
        }
        long convertedNano = this.timeUnit.toNanos(this.timeValue);
        ZonedDateTime startingDate = this.determineInitialDateTime(ticketState);
        ZonedDateTime endingDate = startingDate.plusNanos(convertedNano);
        ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
        LOGGER.trace("Starting date/time [{}]. Ending date/time constraint [{}]. Current date/time [{}]", new Object[]{startingDate, endingDate, currentTime});
        if (currentTime.isBefore(endingDate)) {
            LOGGER.debug("Current time [{}] is before [{}] where SSO participation is granted", (Object)currentTime, (Object)endingDate);
            return true;
        }
        LOGGER.debug("Current time [{}] is after [{}] where SSO participation is rejected", (Object)currentTime, (Object)endingDate);
        return false;
    }

    @JsonIgnore
    protected abstract ZonedDateTime determineInitialDateTime(TicketState var1);

    @Generated
    public String toString() {
        return "BaseDateTimeRegisteredServiceSingleSignOnParticipationPolicy(timeUnit=" + this.timeUnit + ", timeValue=" + this.timeValue + ", order=" + this.order + ")";
    }

    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Generated
    public long getTimeValue() {
        return this.timeValue;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Generated
    public void setTimeValue(long timeValue) {
        this.timeValue = timeValue;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public BaseDateTimeRegisteredServiceSingleSignOnParticipationPolicy() {
    }

    @Generated
    public BaseDateTimeRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit timeUnit, long timeValue, int order) {
        this.timeUnit = timeUnit;
        this.timeValue = timeValue;
        this.order = order;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDateTimeRegisteredServiceSingleSignOnParticipationPolicy)) {
            return false;
        }
        BaseDateTimeRegisteredServiceSingleSignOnParticipationPolicy other = (BaseDateTimeRegisteredServiceSingleSignOnParticipationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TimeUnit this$timeUnit = this.timeUnit;
        TimeUnit other$timeUnit = other.timeUnit;
        if (this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit)) {
            return false;
        }
        if (this.timeValue != other.timeValue) {
            return false;
        }
        return this.order == other.order;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseDateTimeRegisteredServiceSingleSignOnParticipationPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TimeUnit $timeUnit = this.timeUnit;
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        long $timeValue = this.timeValue;
        result = result * 59 + (int)($timeValue >>> 32 ^ $timeValue);
        result = result * 59 + this.order;
        return result;
    }
}

