/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Lob;
import javax.persistence.Table;
import lombok.Generated;
import org.apereo.cas.services.RegisteredServiceProperty;

@Embeddable
@Table(name="RegexRegisteredServiceProperty")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DefaultRegisteredServiceProperty
implements RegisteredServiceProperty {
    private static final long serialVersionUID = 1349556364689133211L;
    @Lob
    @Column(name="property_values")
    private HashSet<String> values = new HashSet();

    public DefaultRegisteredServiceProperty(String ... propertyValues) {
        this.setValues(Arrays.stream(propertyValues).collect(Collectors.toSet()));
    }

    public DefaultRegisteredServiceProperty(Collection<String> propertyValues) {
        this.setValues(new HashSet<String>(propertyValues));
    }

    public Set<String> getValues() {
        if (this.values == null) {
            this.values = new HashSet();
        }
        return this.values;
    }

    public void setValues(Set<String> values) {
        this.getValues().clear();
        if (values == null) {
            return;
        }
        this.getValues().addAll(values);
    }

    @JsonIgnore
    public String getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.iterator().next();
    }

    public boolean contains(String value) {
        return this.values.contains(value);
    }

    public void addValue(String value) {
        this.getValues().add(value);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRegisteredServiceProperty)) {
            return false;
        }
        DefaultRegisteredServiceProperty other = (DefaultRegisteredServiceProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashSet<String> this$values = this.values;
        HashSet<String> other$values = other.values;
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultRegisteredServiceProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashSet<String> $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultRegisteredServiceProperty(values=" + this.values + ")";
    }

    @Generated
    public DefaultRegisteredServiceProperty() {
    }
}

