/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.persistence.Transient;
import lombok.Generated;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class GroovyRegisteredServiceAccessStrategy
implements RegisteredServiceAccessStrategy {
    private static final long serialVersionUID = -2407494148882123062L;
    private int order;
    private String groovyScript;
    @JsonIgnore
    @Transient
    @org.springframework.data.annotation.Transient
    private transient RegisteredServiceAccessStrategy groovyStrategyInstance;

    @JsonIgnore
    public boolean isServiceAccessAllowed() {
        this.buildGroovyAccessStrategyInstanceIfNeeded();
        return this.groovyStrategyInstance.isServiceAccessAllowed();
    }

    @JsonIgnore
    public void setServiceAccessAllowed(boolean enabled) {
        this.buildGroovyAccessStrategyInstanceIfNeeded();
        this.groovyStrategyInstance.setServiceAccessAllowed(enabled);
    }

    @JsonIgnore
    public boolean isServiceAccessAllowedForSso() {
        this.buildGroovyAccessStrategyInstanceIfNeeded();
        return this.groovyStrategyInstance.isServiceAccessAllowedForSso();
    }

    @JsonIgnore
    public boolean doPrincipalAttributesAllowServiceAccess(String principal, Map<String, Object> attributes) {
        this.buildGroovyAccessStrategyInstanceIfNeeded();
        return this.groovyStrategyInstance.doPrincipalAttributesAllowServiceAccess(principal, attributes);
    }

    @JsonIgnore
    public URI getUnauthorizedRedirectUrl() {
        this.buildGroovyAccessStrategyInstanceIfNeeded();
        return this.groovyStrategyInstance.getUnauthorizedRedirectUrl();
    }

    @JsonIgnore
    public RegisteredServiceDelegatedAuthenticationPolicy getDelegatedAuthenticationPolicy() {
        this.buildGroovyAccessStrategyInstanceIfNeeded();
        return this.groovyStrategyInstance.getDelegatedAuthenticationPolicy();
    }

    @JsonIgnore
    public Map<String, Set<String>> getRequiredAttributes() {
        return this.groovyStrategyInstance.getRequiredAttributes();
    }

    private void buildGroovyAccessStrategyInstanceIfNeeded() {
        if (this.groovyStrategyInstance == null) {
            AbstractResource groovyResource = ResourceUtils.getResourceFrom((String)this.groovyScript);
            this.groovyStrategyInstance = (RegisteredServiceAccessStrategy)ScriptingUtils.getObjectInstanceFromGroovyResource((Resource)groovyResource, RegisteredServiceAccessStrategy.class);
        }
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getGroovyScript() {
        return this.groovyScript;
    }

    @Generated
    public RegisteredServiceAccessStrategy getGroovyStrategyInstance() {
        return this.groovyStrategyInstance;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    @Generated
    public void setGroovyStrategyInstance(RegisteredServiceAccessStrategy groovyStrategyInstance) {
        this.groovyStrategyInstance = groovyStrategyInstance;
    }

    @Generated
    public GroovyRegisteredServiceAccessStrategy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroovyRegisteredServiceAccessStrategy)) {
            return false;
        }
        GroovyRegisteredServiceAccessStrategy other = (GroovyRegisteredServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        String this$groovyScript = this.groovyScript;
        String other$groovyScript = other.groovyScript;
        return !(this$groovyScript == null ? other$groovyScript != null : !this$groovyScript.equals(other$groovyScript));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroovyRegisteredServiceAccessStrategy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.order;
        String $groovyScript = this.groovyScript;
        result = result * 59 + ($groovyScript == null ? 43 : $groovyScript.hashCode());
        return result;
    }
}

