/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.regex.Matcher;
import javax.persistence.PostLoad;
import javax.persistence.Transient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.BaseRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledGroovyScript;
import org.apereo.cas.util.scripting.GroovyShellScript;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class GroovyRegisteredServiceUsernameProvider
extends BaseRegisteredServiceUsernameAttributeProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyRegisteredServiceUsernameProvider.class);
    private static final long serialVersionUID = 5823989148794052951L;
    private String groovyScript;
    @JsonIgnore
    @Transient
    @org.springframework.data.annotation.Transient
    private transient ExecutableCompiledGroovyScript executableScript;

    @JsonCreator
    public GroovyRegisteredServiceUsernameProvider(@JsonProperty(value="groovyScript") String script) {
        this.groovyScript = script;
        this.initializeWatchableScriptIfNeeded();
    }

    @PostLoad
    private void initializeWatchableScriptIfNeeded() {
        if (this.executableScript == null) {
            Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)this.groovyScript);
            Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)this.groovyScript);
            if (matcherFile.find()) {
                AbstractResource resource = ResourceUtils.getRawResourceFrom((String)matcherFile.group(1));
                this.executableScript = new WatchableGroovyScriptResource((Resource)resource);
            } else if (matcherInline.find()) {
                this.executableScript = new GroovyShellScript(matcherInline.group(1));
            }
        }
    }

    @Override
    public String resolveUsernameInternal(Principal principal, Service service, RegisteredService registeredService) {
        if (StringUtils.isNotBlank((CharSequence)this.groovyScript)) {
            this.initializeWatchableScriptIfNeeded();
            Object result = this.getGroovyAttributeValue(principal, service);
            if (result != null) {
                LOGGER.debug("Found username [{}] from script", result);
                return result.toString();
            }
        }
        LOGGER.warn("Groovy script [{}] is not valid. CAS will switch to use the default principal identifier [{}]", (Object)this.groovyScript, (Object)principal.getId());
        return principal.getId();
    }

    private Object getGroovyAttributeValue(Principal principal, Service service) {
        Map args = CollectionUtils.wrap((String)"attributes", (Object)principal.getAttributes(), (String)"id", (Object)principal.getId(), (String)"service", (Object)service, (String)"logger", (Object)LOGGER);
        this.executableScript.setBinding(args);
        return this.executableScript.execute(args.values().toArray(), Object.class);
    }

    @Generated
    public String getGroovyScript() {
        return this.groovyScript;
    }

    @Generated
    public ExecutableCompiledGroovyScript getExecutableScript() {
        return this.executableScript;
    }

    @Generated
    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    @Generated
    public void setExecutableScript(ExecutableCompiledGroovyScript executableScript) {
        this.executableScript = executableScript;
    }

    @Generated
    public GroovyRegisteredServiceUsernameProvider() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroovyRegisteredServiceUsernameProvider)) {
            return false;
        }
        GroovyRegisteredServiceUsernameProvider other = (GroovyRegisteredServiceUsernameProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groovyScript = this.groovyScript;
        String other$groovyScript = other.groovyScript;
        return !(this$groovyScript == null ? other$groovyScript != null : !this$groovyScript.equals(other$groovyScript));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroovyRegisteredServiceUsernameProvider;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groovyScript = this.groovyScript;
        result = result * 59 + ($groovyScript == null ? 43 : $groovyScript.hashCode());
        return result;
    }

    @Generated
    public GroovyRegisteredServiceUsernameProvider(String groovyScript, ExecutableCompiledGroovyScript executableScript) {
        this.groovyScript = groovyScript;
        this.executableScript = executableScript;
    }
}

