/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import lombok.Generated;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RegexMatchingRegisteredServiceProxyPolicy
implements RegisteredServiceProxyPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexMatchingRegisteredServiceProxyPolicy.class);
    private static final long serialVersionUID = -211069319543047324L;
    private String pattern;

    @JsonCreator
    public RegexMatchingRegisteredServiceProxyPolicy(@JsonProperty(value="pattern") String pgtUrlPattern) {
        if (RegexUtils.isValidRegex((String)pgtUrlPattern)) {
            this.pattern = pgtUrlPattern;
        } else {
            LOGGER.warn("Pattern specified [{}] is not a valid regular expression", (Object)pgtUrlPattern);
            this.pattern = RegexUtils.MATCH_NOTHING_PATTERN.pattern();
        }
    }

    @JsonIgnore
    public boolean isAllowedToProxy() {
        return true;
    }

    public boolean isAllowedProxyCallbackUrl(URL pgtUrl) {
        return RegexUtils.find((String)this.pattern, (String)pgtUrl.toExternalForm());
    }

    @Generated
    public String toString() {
        return "RegexMatchingRegisteredServiceProxyPolicy(pattern=" + this.pattern + ")";
    }

    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public RegexMatchingRegisteredServiceProxyPolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegexMatchingRegisteredServiceProxyPolicy)) {
            return false;
        }
        RegexMatchingRegisteredServiceProxyPolicy other = (RegexMatchingRegisteredServiceProxyPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pattern = this.pattern;
        String other$pattern = other.pattern;
        return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegexMatchingRegisteredServiceProxyPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.pattern;
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        return result;
    }
}

