/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Optional;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.audit.BaseAuditableExecution;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.inspektr.audit.annotation.Audit;

public class RegisteredServiceAccessStrategyAuditableEnforcer
extends BaseAuditableExecution {
    @Audit(action="SERVICE_ACCESS_ENFORCEMENT", actionResolverName="SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER", resourceResolverName="SERVICE_ACCESS_ENFORCEMENT_RESOURCE_RESOLVER")
    public AuditableExecutionResult execute(AuditableContext context) {
        Optional providedRegisteredService = context.getRegisteredService();
        if (context.getServiceTicket().isPresent() && context.getAuthenticationResult().isPresent() && providedRegisteredService.isPresent()) {
            AuditableExecutionResult result = AuditableExecutionResult.of((AuditableContext)context);
            try {
                RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((ServiceTicket)context.getServiceTicket().get(), (AuthenticationResult)context.getAuthenticationResult().get(), (RegisteredService)providedRegisteredService.get());
            }
            catch (PrincipalException | UnauthorizedServiceException e) {
                result.setException((RuntimeException)e);
            }
            return result;
        }
        Optional providedService = context.getService();
        Optional ticketGrantingTicket = context.getTicketGrantingTicket();
        if (providedService.isPresent() && providedRegisteredService.isPresent() && ticketGrantingTicket.isPresent()) {
            RegisteredService registeredService = (RegisteredService)providedRegisteredService.get();
            Service service = (Service)providedService.get();
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService(registeredService).service(service).ticketGrantingTicket((TicketGrantingTicket)ticketGrantingTicket.get()).build();
            try {
                RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService(service, registeredService, (TicketGrantingTicket)ticketGrantingTicket.get(), (boolean)context.getRetrievePrincipalAttributesFromReleasePolicy().orElse(Boolean.TRUE));
            }
            catch (PrincipalException | UnauthorizedServiceException e) {
                result.setException((RuntimeException)e);
            }
            return result;
        }
        Optional providedAuthn = context.getAuthentication();
        if (providedService.isPresent() && providedRegisteredService.isPresent() && providedAuthn.isPresent()) {
            RegisteredService registeredService = (RegisteredService)providedRegisteredService.get();
            Service service = (Service)providedService.get();
            Authentication authentication = (Authentication)providedAuthn.get();
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService(registeredService).service(service).authentication(authentication).build();
            try {
                RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService(service, registeredService, authentication, (boolean)context.getRetrievePrincipalAttributesFromReleasePolicy().orElse(Boolean.TRUE));
            }
            catch (PrincipalException | UnauthorizedServiceException e) {
                result.setException((RuntimeException)e);
            }
            return result;
        }
        if (providedService.isPresent() && providedRegisteredService.isPresent()) {
            RegisteredService registeredService = (RegisteredService)providedRegisteredService.get();
            Service service = (Service)providedService.get();
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService(registeredService).service(service).build();
            try {
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed(service, registeredService);
            }
            catch (PrincipalException | UnauthorizedServiceException e) {
                result.setException((RuntimeException)e);
            }
            return result;
        }
        if (providedRegisteredService.isPresent()) {
            RegisteredService registeredService = (RegisteredService)providedRegisteredService.get();
            AuditableExecutionResult result = AuditableExecutionResult.builder().registeredService(registeredService).build();
            try {
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed(registeredService);
            }
            catch (PrincipalException | UnauthorizedServiceException e) {
                result.setException((RuntimeException)e);
            }
            return result;
        }
        AuditableExecutionResult result = AuditableExecutionResult.builder().build();
        result.setException((RuntimeException)((Object)new UnauthorizedServiceException("screen.service.error.message", "Service unauthorized")));
        return result;
    }
}

