/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.services.ServiceRegistryProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.service.CasRegisteredServiceExpiredEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicesRefreshEvent;
import org.apereo.cas.util.io.CommunicationsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class RegisteredServicesEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServicesEventListener.class);
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;
    private final CommunicationsManager communicationsManager;

    @EventListener
    @Async
    public void handleRefreshEvent(CasRegisteredServicesRefreshEvent event) {
        this.servicesManager.load();
    }

    @EventListener
    @Async
    public void handleRegisteredServiceExpiredEvent(CasRegisteredServiceExpiredEvent event) {
        String message;
        RegisteredService registeredService = event.getRegisteredService();
        List contacts = registeredService.getContacts();
        ServiceRegistryProperties serviceRegistry = this.casProperties.getServiceRegistry();
        String serviceName = (String)StringUtils.defaultIfBlank((CharSequence)registeredService.getName(), (CharSequence)registeredService.getServiceId());
        if (contacts == null || contacts.isEmpty()) {
            LOGGER.debug("No contacts are defined to be notified for policy changes to service [{}]", (Object)serviceName);
            return;
        }
        if (event.isDeleted()) {
            LOGGER.info("Sending notification to [{}] as registered service [{}] is deleted from service registry", (Object)contacts, (Object)serviceName);
        } else {
            LOGGER.info("Sending notification to [{}] as registered service [{}] is expired in service registry", (Object)contacts, (Object)serviceName);
        }
        this.communicationsManager.validate();
        if (this.communicationsManager.isMailSenderDefined()) {
            EmailProperties mail = serviceRegistry.getMail();
            message = mail.getFormattedBody(new Object[]{serviceName});
            contacts.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getEmail())).forEach(c -> this.communicationsManager.email(mail, c.getEmail(), message));
        }
        if (this.communicationsManager.isSmsSenderDefined()) {
            SmsProperties sms = serviceRegistry.getSms();
            message = sms.getFormattedText(new Object[]{serviceName});
            contacts.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getPhone())).forEach(c -> this.communicationsManager.sms(sms.getFrom(), c.getPhone(), message));
        }
    }

    @Generated
    public RegisteredServicesEventListener(ServicesManager servicesManager, CasConfigurationProperties casProperties, CommunicationsManager communicationsManager) {
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
    }
}

