/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAddonsRegisteredServicesJsonSerializer
extends RegisteredServiceJsonSerializer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasAddonsRegisteredServicesJsonSerializer.class);
    private static final long serialVersionUID = 1874802012930264278L;
    private static final String SERVICE_REGISTRY_FILENAME = "servicesRegistry";
    private static final String SERVICES_KEY = "services";
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();

    public Collection<RegisteredService> load(InputStream stream) {
        ArrayList<RegisteredService> results = new ArrayList<RegisteredService>();
        try {
            Map servicesMap = (Map)this.objectMapper.readValue(stream, Map.class);
            for (Map record : (List)servicesMap.get(SERVICES_KEY)) {
                RegisteredService svc = CasAddonsRegisteredServicesJsonSerializer.convertServiceProperties(record);
                LOGGER.debug("Loaded service [{}] from legacy syntax", (Object)svc);
                results.add(svc);
            }
            LOGGER.warn("CAS has successfully loaded [{}] service(s) which contain definitions designed in a legacy syntax provided by cas-addons. While this behavior is strictly kept for backward-compatibility reasons, it is STRONGLY recommended that you convert these definitions into the official syntax to take full advantage of the service capabilities. Future CAS versions may decide to entirely ignore the legacy syntax altogether.", (Object)results.size());
            results.forEach(Unchecked.consumer(s -> {
                File fileName = new File(FileUtils.getTempDirectory(), s.getName() + "-" + s.getId() + ".json");
                this.to(fileName, s);
                LOGGER.warn("Converted legacy service definition for [{}] may be reviewed at [{}]", (Object)s.getServiceId(), (Object)fileName);
            }));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private static RegisteredService convertServiceProperties(Map serviceDataMap) {
        RegexRegisteredService service = new RegexRegisteredService();
        service.setId(Long.parseLong(serviceDataMap.get("id").toString()));
        service.setName(serviceDataMap.get("name").toString());
        service.setDescription(serviceDataMap.getOrDefault("description", "").toString());
        service.setServiceId(serviceDataMap.get("serviceId").toString().replace("**", ".*"));
        service.setTheme(serviceDataMap.getOrDefault("theme", "").toString());
        service.setEvaluationOrder(Integer.parseInt(((Object)serviceDataMap.getOrDefault("evaluationOrder", Integer.MAX_VALUE)).toString()));
        boolean allowedProxy = Boolean.parseBoolean(((Object)serviceDataMap.getOrDefault("allowedToProxy", Boolean.FALSE)).toString());
        boolean enabled = Boolean.parseBoolean(((Object)serviceDataMap.getOrDefault("enabled", Boolean.TRUE)).toString());
        boolean ssoEnabled = Boolean.parseBoolean(((Object)serviceDataMap.getOrDefault("ssoEnabled", Boolean.TRUE)).toString());
        boolean anonymousAccess = Boolean.parseBoolean(((Object)serviceDataMap.getOrDefault("anonymousAccess", Boolean.TRUE)).toString());
        if (allowedProxy) {
            service.setProxyPolicy(new RegexMatchingRegisteredServiceProxyPolicy(".+"));
        }
        service.setAccessStrategy(new DefaultRegisteredServiceAccessStrategy(enabled, ssoEnabled));
        if (anonymousAccess) {
            service.setUsernameAttributeProvider(new AnonymousRegisteredServiceUsernameAttributeProvider());
        }
        List attributes = serviceDataMap.getOrDefault("allowedAttributes", new ArrayList());
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllowedAttributeReleasePolicy(attributes));
        return service;
    }

    @Override
    public boolean supports(File file) {
        return file.getName().startsWith(SERVICE_REGISTRY_FILENAME);
    }
}

