/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.lang3.NotImplementedException;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.util.RegisteredServiceYamlSerializer;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class RegisteredServiceYamlHttpMessageConverter<T>
extends AbstractHttpMessageConverter<T> {
    public RegisteredServiceYamlHttpMessageConverter() {
        super(new MediaType("application", "vnd.cas.services+yaml"));
    }

    protected boolean supports(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || RegisteredService.class.isAssignableFrom(clazz);
    }

    protected T readInternal(Class<? extends T> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        throw new NotImplementedException("read() operation is not implemented");
    }

    protected void writeInternal(T t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), StandardCharsets.UTF_8);){
            RegisteredServiceYamlSerializer serializer = new RegisteredServiceYamlSerializer();
            if (t instanceof Collection) {
                ((Collection)Collection.class.cast(t)).stream().filter(object -> object instanceof RegisteredService).forEach(service -> serializer.to(writer, (RegisteredService)RegisteredService.class.cast(service)));
            } else if (t instanceof RegisteredService) {
                serializer.to(writer, (RegisteredService)RegisteredService.class.cast(t));
            }
        }
    }
}

