/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.credential.HttpBasedServiceCredential;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Authentication")
class HttpBasedServiceCredentialTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "httpBasedServiceCredential.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    HttpBasedServiceCredentialTests() {
    }

    @Test
    void verifyProperUrl() throws Throwable {
        Assertions.assertEquals((Object)"https://github.com/", (Object)CoreAuthenticationTestUtils.getHttpBasedServiceCredentials().getCallbackUrl().toExternalForm());
    }

    @Test
    void verifyEqualsWithNull() throws Throwable {
        CasModelRegisteredService registeredService = CoreAuthenticationTestUtils.getRegisteredService((String)"https://google.com");
        HttpBasedServiceCredential c = new HttpBasedServiceCredential(new URI("https://github.com/").toURL(), registeredService);
        Assertions.assertNotEquals(null, (Object)c);
    }

    @Test
    void verifyEqualsWithFalse() throws Throwable {
        CasModelRegisteredService registeredService = CoreAuthenticationTestUtils.getRegisteredService((String)"https://google.com");
        HttpBasedServiceCredential c = new HttpBasedServiceCredential(new URI("https://github.com/").toURL(), registeredService);
        HttpBasedServiceCredential c2 = new HttpBasedServiceCredential(new URI("http://www.msn.com").toURL(), registeredService);
        Assertions.assertNotEquals((Object)c2, (Object)c);
        Assertions.assertNotEquals((Object)new Object(), (Object)c);
    }

    @Test
    void verifyEqualsWithTrue() throws Throwable {
        CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService("https://google.com");
        URL callbackUrl = new URI("https://github.com/").toURL();
        HttpBasedServiceCredential c = new HttpBasedServiceCredential(callbackUrl, (CasModelRegisteredService)registeredService);
        HttpBasedServiceCredential c2 = new HttpBasedServiceCredential(callbackUrl, (CasModelRegisteredService)registeredService);
        Assertions.assertEquals((Object)c2, (Object)c);
        Assertions.assertEquals((Object)c, (Object)c2);
    }

    @Test
    void verifySerializeAnHttpBasedServiceCredentialToJson() throws Throwable {
        HttpBasedServiceCredential credentialMetaDataWritten = new HttpBasedServiceCredential(new URI("https://github.com/").toURL(), (CasModelRegisteredService)RegisteredServiceTestUtils.getRegisteredService("https://google.com"));
        MAPPER.writeValue(JSON_FILE, (Object)credentialMetaDataWritten);
        HttpBasedServiceCredential credentialMetaDataRead = (HttpBasedServiceCredential)MAPPER.readValue(JSON_FILE, HttpBasedServiceCredential.class);
        Assertions.assertEquals((Object)credentialMetaDataWritten, (Object)credentialMetaDataRead);
    }
}

