/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.handler.support;

import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.SimpleHttpClient;
import org.apereo.cas.util.http.SimpleHttpClientFactoryBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="AuthenticationHandler")
class HttpBasedServiceCredentialsAuthenticationHandlerTests {
    private HttpBasedServiceCredentialsAuthenticationHandler authenticationHandler;

    HttpBasedServiceCredentialsAuthenticationHandlerTests() {
    }

    @BeforeEach
    public void initialize() {
        this.authenticationHandler = new HttpBasedServiceCredentialsAuthenticationHandler("", null, null, null, (HttpClient)new SimpleHttpClientFactoryBean().getObject());
    }

    @Test
    void verifySupportsProperUserCredentials() throws Throwable {
        Assertions.assertTrue((boolean)this.authenticationHandler.supports((Credential)RegisteredServiceTestUtils.getHttpBasedServiceCredentials()));
        Assertions.assertTrue((boolean)this.authenticationHandler.supports(RegisteredServiceTestUtils.getHttpBasedServiceCredentials().getClass()));
    }

    @Test
    void verifyDoesntSupportBadUserCredentials() throws Throwable {
        Assertions.assertFalse((boolean)this.authenticationHandler.supports((Credential)RegisteredServiceTestUtils.getCredentialsWithDifferentUsernameAndPassword("test", "test2")));
    }

    @Test
    void verifyAcceptsProperCertificateCredentials() throws Throwable {
        Assertions.assertNotNull((Object)this.authenticationHandler.authenticate((Credential)RegisteredServiceTestUtils.getHttpBasedServiceCredentials(), (Service)RegisteredServiceTestUtils.getService()));
    }

    @Test
    void verifyRejectsInProperCertificateCredentials() throws Throwable {
        Assertions.assertThrows(FailedLoginException.class, () -> this.authenticationHandler.authenticate((Credential)RegisteredServiceTestUtils.getHttpBasedServiceCredentials("https://clearinghouse.ja-sig.org"), (Service)RegisteredServiceTestUtils.getService()));
    }

    @Test
    void verifyAcceptsNonHttpsCredentials() throws Throwable {
        Assertions.assertNotNull((Object)this.authenticationHandler.authenticate((Credential)RegisteredServiceTestUtils.getHttpBasedServiceCredentials("http://www.google.com"), (Service)RegisteredServiceTestUtils.getService()));
    }

    @Test
    void verifyNoAcceptableStatusCode() throws Throwable {
        Assertions.assertThrows(FailedLoginException.class, () -> this.authenticationHandler.authenticate((Credential)RegisteredServiceTestUtils.getHttpBasedServiceCredentials("https://clue.acs.rutgers.edu"), (Service)RegisteredServiceTestUtils.getService()));
    }

    @Test
    void verifyNoAcceptableStatusCodeButOneSet() throws Throwable {
        SimpleHttpClientFactoryBean clientFactory = new SimpleHttpClientFactoryBean();
        clientFactory.setAcceptableCodes(CollectionUtils.wrapList((Object[])new Integer[]{900}));
        SimpleHttpClient httpClient = clientFactory.getObject();
        this.authenticationHandler = new HttpBasedServiceCredentialsAuthenticationHandler("", null, null, null, (HttpClient)httpClient);
        Assertions.assertThrows(FailedLoginException.class, () -> this.authenticationHandler.authenticate((Credential)RegisteredServiceTestUtils.getHttpBasedServiceCredentials("https://www.ja-sig.org"), (Service)RegisteredServiceTestUtils.getService()));
    }
}

