/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.HashMap;
import org.apereo.cas.authentication.principal.DefaultResponse;
import org.apereo.cas.authentication.principal.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Authentication")
class ResponseTests {
    private static final String TICKET_PARAM = "ticket";
    private static final String TICKET_VALUE = "foobar";

    ResponseTests() {
    }

    @Test
    void verifyConstructionWithoutFragmentAndNoQueryString() throws Throwable {
        String url = "http://localhost:8080/foo";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TICKET_PARAM, TICKET_VALUE);
        Response response = DefaultResponse.getRedirectResponse((String)"http://localhost:8080/foo", attributes);
        Assertions.assertEquals((Object)"http://localhost:8080/foo?ticket=foobar", (Object)response.url());
    }

    @Test
    void verifyConstructionWithoutFragmentButHasQueryString() throws Throwable {
        String url = "http://localhost:8080/foo?test=boo";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TICKET_PARAM, TICKET_VALUE);
        Response response = DefaultResponse.getRedirectResponse((String)"http://localhost:8080/foo?test=boo", attributes);
        Assertions.assertEquals((Object)"http://localhost:8080/foo?test=boo&ticket=foobar", (Object)response.url());
    }

    @Test
    void verifyConstructionWithFragmentAndQueryString() throws Throwable {
        String url = "http://localhost:8080/foo?test=boo#hello";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TICKET_PARAM, TICKET_VALUE);
        Response response = DefaultResponse.getRedirectResponse((String)"http://localhost:8080/foo?test=boo#hello", attributes);
        Assertions.assertEquals((Object)"http://localhost:8080/foo?test=boo&ticket=foobar#hello", (Object)response.url());
    }

    @Test
    void verifyConstructionWithFragmentAndNoQueryString() throws Throwable {
        String url = "http://localhost:8080/foo#hello";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TICKET_PARAM, TICKET_VALUE);
        Response response = DefaultResponse.getRedirectResponse((String)"http://localhost:8080/foo#hello", attributes);
        Assertions.assertEquals((Object)"http://localhost:8080/foo?ticket=foobar#hello", (Object)response.url());
    }

    @Test
    void verifyConstructionWithFragmentAndNoQueryString2() throws Throwable {
        String url = "http://localhost:8080/foo#hello?test=boo";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TICKET_PARAM, TICKET_VALUE);
        Response response = DefaultResponse.getRedirectResponse((String)"http://localhost:8080/foo#hello?test=boo", attributes);
        Assertions.assertEquals((Object)"http://localhost:8080/foo?ticket=foobar#hello?test=boo", (Object)response.url());
    }

    @Test
    void verifyUrlSanitization() throws Throwable {
        String url = "https://www.example.com\r\nLocation: javascript:\r\n\r\n<script>alert(document.cookie)</script>";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TICKET_PARAM, "ST-12345");
        Response response = DefaultResponse.getRedirectResponse((String)"https://www.example.com\r\nLocation: javascript:\r\n\r\n<script>alert(document.cookie)</script>", attributes);
        Assertions.assertEquals((Object)"https://www.example.com Location: javascript: <script>alert(document.cookie)</script>?ticket=ST-12345", (Object)response.url());
    }

    @Test
    void verifyUrlWithUnicode() throws Throwable {
        String url = "https://www.example.com/\u03c0\u03bf\u03bb\u03b9\u03c4\u03b9\u03ba\u1ff6\u03bd";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TICKET_PARAM, "ST-12345");
        Response response = DefaultResponse.getRedirectResponse((String)"https://www.example.com/\u03c0\u03bf\u03bb\u03b9\u03c4\u03b9\u03ba\u1ff6\u03bd", attributes);
        Assertions.assertEquals((Object)"https://www.example.com/\u03c0\u03bf\u03bb\u03b9\u03c4\u03b9\u03ba\u1ff6\u03bd?ticket=ST-12345", (Object)response.url());
    }

    @Test
    void verifyUrlWithUrn() throws Throwable {
        String url = "urn:applis-cri:java-sso";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TICKET_PARAM, "ST-123456");
        Response response = DefaultResponse.getRedirectResponse((String)"urn:applis-cri:java-sso", attributes);
        Assertions.assertEquals((Object)"urn:applis-cri:java-sso?ticket=ST-123456", (Object)response.url());
    }
}

