/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="RegisteredService")
class ShibbolethCompatiblePersistentIdGeneratorTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "shibbolethCompatiblePersistentIdGenerator.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    ShibbolethCompatiblePersistentIdGeneratorTests() {
    }

    @Test
    void verifyGenerator() throws Throwable {
        ShibbolethCompatiblePersistentIdGenerator generator = new ShibbolethCompatiblePersistentIdGenerator("scottssalt");
        Assertions.assertNotNull((Object)generator.toString());
        Principal p = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)p.getId()).thenReturn((Object)"testuser");
        String value = generator.generate(p, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertNotNull((Object)value);
    }

    @Test
    void verifyGeneratorByPrincipal() throws Throwable {
        Map<String, List<String>> attrs = Map.of("uid", List.of("testuser"));
        ShibbolethCompatiblePersistentIdGenerator generator = new ShibbolethCompatiblePersistentIdGenerator();
        generator.setAttribute("uid");
        Assertions.assertNotNull((Object)generator.toString());
        Assertions.assertNotNull((Object)generator.determinePrincipalIdFromAttributes("uid", attrs));
        Principal p = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)p.getAttributes()).thenReturn(attrs);
        Mockito.when((Object)p.getId()).thenReturn((Object)"testuser");
        String value = generator.generate(p, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertNotNull((Object)value);
    }

    @Test
    void realTestOfGeneratorThatVerifiesValueReturned() {
        ShibbolethCompatiblePersistentIdGenerator generator = new ShibbolethCompatiblePersistentIdGenerator("thisisasalt");
        Principal p = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)p.getId()).thenReturn((Object)"grudkin");
        Service s = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)s.getId()).thenReturn((Object)"https://shibboleth.irbmanager.com/");
        String value = generator.generate(p, s);
        Assertions.assertEquals((Object)"jvZO/wYedArYIEIORGdHoMO4qkw=", (Object)value);
    }

    @Test
    void verifyJson() throws IOException {
        ShibbolethCompatiblePersistentIdGenerator generatorWritten = new ShibbolethCompatiblePersistentIdGenerator("scottssalt");
        MAPPER.writeValue(JSON_FILE, (Object)generatorWritten);
        ShibbolethCompatiblePersistentIdGenerator credentialRead = (ShibbolethCompatiblePersistentIdGenerator)MAPPER.readValue(JSON_FILE, ShibbolethCompatiblePersistentIdGenerator.class);
        Assertions.assertEquals((Object)generatorWritten, (Object)credentialRead);
    }
}

