/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationServiceResponseBuilder;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.mgmt.DefaultServicesManager;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.SimpleUrlValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="Authentication")
class SimpleWebApplicationServiceImplTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "simpleWebApplicationServiceImpl.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    SimpleWebApplicationServiceImplTests() {
    }

    private static ServicesManager getServicesManager(StaticApplicationContext applicationContext) {
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().registeredServicesTemplatesManager((RegisteredServicesTemplatesManager)Mockito.mock(RegisteredServicesTemplatesManager.class)).serviceRegistry((ServiceRegistry)Mockito.mock(ServiceRegistry.class)).applicationContext((ConfigurableApplicationContext)applicationContext).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        return new DefaultServicesManager(context);
    }

    @Test
    void verifySerializeACompletePrincipalToJson() throws IOException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "https://google.com");
        WebApplicationService serviceWritten = new WebApplicationServiceFactory().createService((HttpServletRequest)request);
        MAPPER.writeValue(JSON_FILE, (Object)serviceWritten);
        SimpleWebApplicationServiceImpl serviceRead = (SimpleWebApplicationServiceImpl)MAPPER.readValue(JSON_FILE, SimpleWebApplicationServiceImpl.class);
        Assertions.assertEquals((Object)serviceWritten, (Object)serviceRead);
    }

    @Test
    void verifyResponse() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "https://google.com");
        WebApplicationService impl = new WebApplicationServiceFactory().createService((HttpServletRequest)request);
        Response response = new WebApplicationServiceResponseBuilder(SimpleWebApplicationServiceImplTests.getServicesManager(applicationContext), SimpleUrlValidator.getInstance()).build(impl, "ticketId", RegisteredServiceTestUtils.getAuthentication());
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.responseType());
    }

    @Test
    void verifyCreateSimpleWebApplicationServiceImplFromServiceAttribute() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("service", (Object)"https://google.com");
        WebApplicationService impl = new WebApplicationServiceFactory().createService((HttpServletRequest)request);
        Assertions.assertNotNull((Object)impl);
    }

    @Test
    void verifyResponseForJsession() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "http://www.cnn.com/;jsession=test");
        WebApplicationService impl = new WebApplicationServiceFactory().createService((HttpServletRequest)request);
        Assertions.assertEquals((Object)"http://www.cnn.com/", (Object)impl.getId());
    }

    @Test
    void verifyResponseWithNoTicket() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "https://google.com");
        WebApplicationService impl = new WebApplicationServiceFactory().createService((HttpServletRequest)request);
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        Response response = new WebApplicationServiceResponseBuilder(SimpleWebApplicationServiceImplTests.getServicesManager(applicationContext), SimpleUrlValidator.getInstance()).build(impl, null, RegisteredServiceTestUtils.getAuthentication());
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.responseType());
        Assertions.assertFalse((boolean)response.url().contains("ticket="));
    }

    @Test
    void verifyResponseWithNoTicketAndNoParameterInServiceURL() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "http://foo.com/");
        WebApplicationService impl = new WebApplicationServiceFactory().createService((HttpServletRequest)request);
        Response response = new WebApplicationServiceResponseBuilder(SimpleWebApplicationServiceImplTests.getServicesManager(applicationContext), SimpleUrlValidator.getInstance()).build(impl, null, RegisteredServiceTestUtils.getAuthentication());
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.responseType());
        Assertions.assertFalse((boolean)response.url().contains("ticket="));
        Assertions.assertEquals((Object)"http://foo.com/", (Object)response.url());
    }

    @Test
    void verifyResponseWithNoTicketAndOneParameterInServiceURL() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "http://foo.com/?param=test");
        WebApplicationService impl = new WebApplicationServiceFactory().createService((HttpServletRequest)request);
        Response response = new WebApplicationServiceResponseBuilder(SimpleWebApplicationServiceImplTests.getServicesManager(applicationContext), SimpleUrlValidator.getInstance()).build(impl, null, RegisteredServiceTestUtils.getAuthentication());
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.responseType());
        Assertions.assertEquals((Object)"http://foo.com/?param=test", (Object)response.url());
    }
}

