/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Tag(value="Authentication")
class WebApplicationServiceFactoryTests {
    WebApplicationServiceFactoryTests() {
    }

    @Test
    void verifyServiceAttributes() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("p1", "v1");
        request.addParameter("p2", "v2");
        request.addParameter("password", "m$hf74621");
        request.addParameter("service", "https://example.org?p3=v3&p4=v4");
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService((HttpServletRequest)request);
        Assertions.assertNotNull((Object)service);
        Assertions.assertEquals((int)7, (int)service.getAttributes().size());
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("p1"));
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("p2"));
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("p3"));
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("p4"));
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("%s.requestURL".formatted(HttpServletRequest.class.getName())));
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("%s.localeName".formatted(HttpServletRequest.class.getName())));
        Assertions.assertFalse((boolean)service.getAttributes().containsKey("password"));
    }

    @Test
    void verifyServiceCreationSuccessfullyById() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService("testservice");
        Assertions.assertNotNull((Object)service);
    }

    @Test
    void verifyServiceCreationSuccessfullyByService() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("service", "test");
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService((HttpServletRequest)request);
        Assertions.assertNotNull((Object)service);
        Assertions.assertEquals((Object)"service", (Object)service.getSource());
    }

    @Test
    void verifyServiceCreationSuccessfullyByTargetService() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("targetService", "test");
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService((HttpServletRequest)request);
        Assertions.assertNotNull((Object)service);
        Assertions.assertEquals((Object)"targetService", (Object)service.getSource());
    }

    @Test
    void verifyServiceCreationSuccessfullyByTargetServiceAndTicket() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("targetService", "test");
        request.addParameter("ticket", "ticket");
        request.addParameter("method", "post");
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService((HttpServletRequest)request);
        Assertions.assertNotNull((Object)service);
        Assertions.assertEquals((Object)"ticket", (Object)service.getArtifactId());
    }

    @Test
    void verifyServiceCreationNoService() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("ticket", "ticket");
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService((HttpServletRequest)request);
        Assertions.assertNull((Object)service);
    }

    @Test
    void verifyServiceCreationNoRequest() throws Throwable {
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService("testservice");
        Assertions.assertNotNull((Object)service);
    }

    @Test
    void verifyServiceByClass() throws Throwable {
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        Assertions.assertThrows(ClassCastException.class, () -> factory.createService("testservice", ((Service)Mockito.mock(Service.class)).getClass()));
        Assertions.assertNotNull((Object)factory.createService("testservice", WebApplicationService.class));
    }

    @Test
    void verifyServiceByClassReq() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("targetService", "test");
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        Assertions.assertThrows(ClassCastException.class, () -> factory.createService((HttpServletRequest)request, ((Service)Mockito.mock(Service.class)).getClass()));
        Assertions.assertNotNull((Object)factory.createService((HttpServletRequest)request, WebApplicationService.class));
    }
}

