/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationTextPublisher;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apereo.cas.config.CasCoreMonitorConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreServicesMonitoringConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.autoconfigure.actuate.observability.AutoConfigureObservability;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@SpringBootTest(classes={RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class, ObservationAutoConfiguration.class, CasCoreServicesConfiguration.class, CasCoreServicesMonitoringTestConfiguration.class, CasCoreMonitorConfiguration.class, CasCoreUtilConfiguration.class, CasCoreWebConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesMonitoringConfiguration.class})
@Tag(value="RegisteredService")
@EnableAspectJAutoProxy(proxyTargetClass=false)
@AutoConfigureObservability
class CasCoreServicesMonitoringConfigurationTests {
    private static final List<String> ENTRIES = new ArrayList<String>();
    @Autowired
    @Qualifier(value="servicesManager")
    protected ServicesManager servicesManager;

    CasCoreServicesMonitoringConfigurationTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService(UUID.randomUUID().toString());
        this.servicesManager.load();
        this.servicesManager.save((RegisteredService)registeredService);
        Assertions.assertNotNull((Object)this.servicesManager.findServiceBy(registeredService.getId()));
        this.servicesManager.delete(registeredService.getId());
        this.servicesManager.deleteAll();
        Assertions.assertFalse((boolean)ENTRIES.isEmpty());
    }

    @TestConfiguration(proxyBeanMethods=false)
    static class CasCoreServicesMonitoringTestConfiguration {
        CasCoreServicesMonitoringTestConfiguration() {
        }

        @Bean
        public ObservationHandler<Observation.Context> collectingObservationHandler() {
            return new ObservationTextPublisher(ENTRIES::add);
        }
    }
}

